/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.boot;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hibernate.boot.registry.classloading.internal.ClassLoaderServiceImpl;

public class ExtraJavaServicesClassLoaderService
extends ClassLoaderServiceImpl {
    private final List<JavaServiceDescriptor<?>> extraJavaServices;

    public ExtraJavaServicesClassLoaderService(List<JavaServiceDescriptor<?>> extraJavaServices) {
        this.extraJavaServices = extraJavaServices;
    }

    public <S> Collection<S> loadJavaServices(Class<S> serviceContract) {
        Collection baseServices = super.loadJavaServices(serviceContract);
        ArrayList services = new ArrayList(baseServices);
        this.applyExtraJavaServices(serviceContract, services);
        return services;
    }

    private <S> void applyExtraJavaServices(Class<S> serviceContract, List<S> services) {
        this.extraJavaServices.forEach(javaServiceDescriptor -> {
            if (serviceContract.isAssignableFrom(javaServiceDescriptor.role)) {
                try {
                    Object serviceInstance = javaServiceDescriptor.impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    services.add(serviceInstance);
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new RuntimeException("Unable to access constructor for specified 'extra' Java service : " + javaServiceDescriptor.impl.getName(), e);
                }
                catch (InstantiationException | InvocationTargetException e) {
                    throw new RuntimeException("Unable to instantiate specified 'extra' Java service : " + javaServiceDescriptor.impl.getName(), e);
                }
            }
        });
    }

    public static class JavaServiceDescriptor<ROLE> {
        private final Class<ROLE> role;
        private final Class<? extends ROLE> impl;

        public JavaServiceDescriptor(Class<ROLE> role, Class<? extends ROLE> impl) {
            this.role = role;
            this.impl = impl;
        }

        public Class<ROLE> getRole() {
            return this.role;
        }

        public Class<? extends ROLE> getImpl() {
            return this.impl;
        }
    }
}

