/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.query.IllegalQueryOperationException;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.delete.DeleteStatement;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.DerivedTableReference;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.insert.ConflictClause;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.select.SortSpecification;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SQLServerLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    private static final String UNION_ALL = " union all ";
    private Predicate lateralPredicate;

    public SQLServerLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void visitInsertStatementOnly(InsertSelectStatement statement) {
        if (statement.getConflictClause() == null || statement.getConflictClause().isDoNothing()) {
            super.visitInsertStatementOnly(statement);
        } else {
            this.visitInsertStatementEmulateMerge(statement);
            this.appendSql(';');
        }
    }

    protected void renderDeleteClause(DeleteStatement statement) {
        this.appendSql("delete");
        Stack clauseStack = this.getClauseStack();
        try {
            clauseStack.push((Object)Clause.DELETE);
            this.renderTableReferenceIdentificationVariable((TableReference)statement.getTargetTable());
            if (statement.getFromClause().getRoots().isEmpty()) {
                this.appendSql(" from ");
                this.renderDmlTargetTableExpression(statement.getTargetTable());
            } else {
                this.visitFromClause(statement.getFromClause());
            }
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void renderUpdateClause(UpdateStatement updateStatement) {
        this.appendSql("update");
        Stack clauseStack = this.getClauseStack();
        try {
            clauseStack.push((Object)Clause.UPDATE);
            this.renderTableReferenceIdentificationVariable((TableReference)updateStatement.getTargetTable());
        }
        finally {
            clauseStack.pop();
        }
    }

    protected void renderDmlTargetTableExpression(NamedTableReference tableReference) {
        super.renderDmlTargetTableExpression(tableReference);
        if (this.getClauseStack().getCurrent() != Clause.INSERT) {
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        }
    }

    protected void renderFromClauseAfterUpdateSet(UpdateStatement statement) {
        if (statement.getFromClause().getRoots().isEmpty()) {
            this.appendSql(" from ");
            this.renderDmlTargetTableExpression(statement.getTargetTable());
        } else {
            this.visitFromClause(statement.getFromClause());
        }
    }

    protected void visitConflictClause(ConflictClause conflictClause) {
        if (conflictClause != null && conflictClause.isDoUpdate() && conflictClause.getConstraintName() != null) {
            throw new IllegalQueryOperationException("Insert conflict 'do update' clause with constraint name is not supported");
        }
    }

    protected boolean needsRecursiveKeywordInWithClause() {
        return false;
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        this.appendSql(' ');
        if (tableGroupJoin.getJoinedGroup().isLateral()) {
            if (tableGroupJoin.getJoinType() == SqlAstJoinType.LEFT) {
                this.appendSql("outer apply ");
            } else {
                this.appendSql("cross apply ");
            }
        } else {
            this.appendSql(tableGroupJoin.getJoinType().getText());
            this.appendSql("join ");
        }
        Predicate predicate = tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            if (tableGroupJoin.getJoinedGroup().isLateral()) {
                Predicate lateralPredicate = this.lateralPredicate;
                this.lateralPredicate = predicate;
                this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
                this.lateralPredicate = lateralPredicate;
            } else {
                this.renderTableGroup(tableGroupJoin.getJoinedGroup(), predicate, tableGroupJoinCollector);
            }
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected void renderDerivedTableReference(DerivedTableReference tableReference) {
        tableReference.accept((SqlAstWalker)this);
    }

    public void renderNamedSetReturningFunction(String functionName, List<? extends SqlAstNode> sqlAstArguments, AnonymousTupleTableGroupProducer tupleType, String tableIdentifierVariable, SqlAstNodeRenderingMode argumentRenderingMode) {
        ModelPart ordinalitySubPart = tupleType.findSubPart(CollectionPart.Nature.INDEX.getName(), null);
        if (ordinalitySubPart != null) {
            this.appendSql("(select t.*, row_number() over(order by (select 1)) ");
            this.appendSql(ordinalitySubPart.asBasicValuedModelPart().getSelectionExpression());
            this.appendSql(" from ");
            this.renderSimpleNamedFunction(functionName, sqlAstArguments, argumentRenderingMode);
            this.append(" t)");
        } else {
            super.renderNamedSetReturningFunction(functionName, sqlAstArguments, tupleType, tableIdentifierVariable, argumentRenderingMode);
        }
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        String tableExpression = tableReference.getTableExpression();
        if (tableReference instanceof UnionTableReference && lockMode != LockMode.NONE && tableExpression.charAt(0) == '(') {
            int unionIndex;
            int searchIndex = 0;
            while ((unionIndex = tableExpression.indexOf(UNION_ALL, searchIndex)) != -1) {
                this.append(tableExpression, searchIndex, unionIndex);
                this.renderLockHint(lockMode);
                this.appendSql(UNION_ALL);
                searchIndex = unionIndex + UNION_ALL.length();
            }
            this.append(tableExpression, searchIndex, tableExpression.length() - 1);
            this.renderLockHint(lockMode);
            this.appendSql(" )");
            this.registerAffectedTable(tableReference);
            this.renderTableReferenceIdentificationVariable((TableReference)tableReference);
        } else {
            super.renderNamedTableReference(tableReference, lockMode);
            this.renderLockHint(lockMode);
        }
        return true;
    }

    private void renderLockHint(LockMode lockMode) {
        if (this.getDialect().getVersion().isSameOrAfter(9)) {
            int effectiveLockTimeout = this.getEffectiveLockTimeout(lockMode);
            block0 : switch (lockMode) {
                case PESSIMISTIC_WRITE: 
                case WRITE: {
                    switch (effectiveLockTimeout) {
                        case -2: {
                            this.appendSql(" with (updlock,rowlock,readpast)");
                            break block0;
                        }
                        case 0: {
                            this.appendSql(" with (updlock,holdlock,rowlock,nowait)");
                            break block0;
                        }
                    }
                    this.appendSql(" with (updlock,holdlock,rowlock)");
                    break;
                }
                case PESSIMISTIC_READ: {
                    switch (effectiveLockTimeout) {
                        case -2: {
                            this.appendSql(" with (updlock,rowlock,readpast)");
                            break block0;
                        }
                        case 0: {
                            this.appendSql(" with (holdlock,rowlock,nowait)");
                            break block0;
                        }
                    }
                    this.appendSql(" with (holdlock,rowlock)");
                    break;
                }
                case UPGRADE_SKIPLOCKED: {
                    if (effectiveLockTimeout == 0) {
                        this.appendSql(" with (updlock,rowlock,readpast,nowait)");
                        break;
                    }
                    this.appendSql(" with (updlock,rowlock,readpast)");
                    break;
                }
                case UPGRADE_NOWAIT: {
                    this.appendSql(" with (updlock,holdlock,rowlock,nowait)");
                }
            }
        } else {
            switch (lockMode) {
                case PESSIMISTIC_WRITE: 
                case WRITE: 
                case UPGRADE_NOWAIT: {
                    this.appendSql(" with (updlock,rowlock)");
                    break;
                }
                case PESSIMISTIC_READ: {
                    this.appendSql(" with (holdlock,rowlock)");
                    break;
                }
                case UPGRADE_SKIPLOCKED: {
                    this.appendSql(" with (updlock,rowlock,readpast)");
                }
            }
        }
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        return AbstractSqlAstTranslator.LockStrategy.CLAUSE;
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
    }

    protected OffsetFetchClauseMode getOffsetFetchClauseMode(QueryPart queryPart) {
        boolean hasOffset;
        boolean hasLimit;
        DatabaseVersion version = this.getDialect().getVersion();
        if (queryPart.isRoot() && this.hasLimit()) {
            hasLimit = this.getLimit().getMaxRows() != null;
            hasOffset = this.getLimit().getFirstRow() != null;
        } else {
            hasLimit = queryPart.getFetchClauseExpression() != null;
            boolean bl = hasOffset = queryPart.getOffsetClauseExpression() != null;
        }
        if (queryPart instanceof QueryGroup) {
            if (hasOffset || hasLimit) {
                if (version.isBefore(11) || !this.isRowsOnlyFetchClauseType(queryPart)) {
                    return OffsetFetchClauseMode.EMULATED;
                }
                return OffsetFetchClauseMode.STANDARD;
            }
            return null;
        }
        if (version.isBefore(9) || !hasOffset) {
            return hasLimit ? OffsetFetchClauseMode.TOP_ONLY : null;
        }
        if (version.isBefore(11) || !this.isRowsOnlyFetchClauseType(queryPart)) {
            return OffsetFetchClauseMode.EMULATED;
        }
        if (!queryPart.hasSortSpecifications() && ((QuerySpec)queryPart).getSelectClause().isDistinct()) {
            return OffsetFetchClauseMode.EMULATED;
        }
        return OffsetFetchClauseMode.STANDARD;
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.getQueryPartForRowNumbering() != queryPart && this.getOffsetFetchClauseMode(queryPart) == OffsetFetchClauseMode.EMULATED;
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        Predicate lateralPredicate = this.lateralPredicate;
        if (lateralPredicate != null) {
            this.lateralPredicate = null;
            this.addAdditionalWherePredicate(lateralPredicate);
        }
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, !this.isRowsOnlyFetchClauseType((QueryPart)queryGroup));
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, !this.isRowsOnlyFetchClauseType((QueryPart)querySpec));
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitSelectClause(SelectClause selectClause) {
        if (this.lateralPredicate != null) {
            this.addAdditionalWherePredicate(this.lateralPredicate);
            this.lateralPredicate = null;
        }
        super.visitSelectClause(selectClause);
    }

    protected boolean needsRowsToSkip() {
        return this.getDialect().getVersion().isBefore(9);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        QuerySpec querySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
        OffsetFetchClauseMode offsetFetchClauseMode = this.getOffsetFetchClauseMode((QueryPart)querySpec);
        if (offsetFetchClauseMode == OffsetFetchClauseMode.TOP_ONLY) {
            this.renderTopClause(querySpec, true, true);
        } else if (offsetFetchClauseMode == OffsetFetchClauseMode.EMULATED) {
            this.renderTopClause(querySpec, this.isRowsOnlyFetchClauseType((QueryPart)querySpec), true);
        } else if (this.getQueryPartStack().depth() > 1 && querySpec.hasSortSpecifications() && this.getQueryPartStack().peek(1) instanceof QueryGroup) {
            this.appendSql("top 100 percent ");
        }
        super.visitSqlSelections(selectClause);
    }

    protected void renderOrderBy(boolean addWhitespace, List<SortSpecification> sortSpecifications) {
        if (sortSpecifications != null && !sortSpecifications.isEmpty()) {
            super.renderOrderBy(addWhitespace, sortSpecifications);
        } else if (this.getClauseStack().getCurrent() == Clause.OVER) {
            if (addWhitespace) {
                this.appendSql(' ');
            }
            this.renderEmptyOrderBy();
        }
    }

    protected void renderEmptyOrderBy() {
        this.appendSql("order by (select 0)");
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            if (this.getDialect().getVersion().isBefore(9) && !queryPart.isRoot() && queryPart.getOffsetClauseExpression() != null) {
                throw new IllegalArgumentException("Can't emulate offset clause in subquery");
            }
            OffsetFetchClauseMode offsetFetchClauseMode = this.getOffsetFetchClauseMode(queryPart);
            if (offsetFetchClauseMode == OffsetFetchClauseMode.STANDARD) {
                FetchClauseType fetchClauseType;
                Expression fetchExpression;
                Expression offsetExpression;
                if (!queryPart.hasSortSpecifications()) {
                    this.appendSql(' ');
                    this.renderEmptyOrderBy();
                }
                if (queryPart.isRoot() && this.hasLimit()) {
                    this.prepareLimitOffsetParameters();
                    offsetExpression = this.getOffsetParameter();
                    fetchExpression = this.getLimitParameter();
                    fetchClauseType = FetchClauseType.ROWS_ONLY;
                } else {
                    offsetExpression = queryPart.getOffsetClauseExpression();
                    fetchExpression = queryPart.getFetchClauseExpression();
                    fetchClauseType = queryPart.getFetchClauseType();
                }
                if (offsetExpression == null) {
                    this.appendSql(" offset 0 rows");
                } else {
                    this.renderOffset(offsetExpression, true);
                }
                if (fetchExpression != null) {
                    this.renderFetch(fetchExpression, null, fetchClauseType);
                }
            }
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        JdbcMappingContainer lhsExpressionType = lhs.getExpressionType();
        if (lhsExpressionType != null && lhsExpressionType.getJdbcTypeCount() == 1 && lhsExpressionType.getSingleJdbcMapping().getJdbcType().getDdlTypeCode() == 2009) {
            switch (operator) {
                case DISTINCT_FROM: {
                    if (!this.getDialect().supportsDistinctFromPredicate()) {
                        this.appendSql("not ");
                    }
                }
                case NOT_DISTINCT_FROM: {
                    if (!this.getDialect().supportsDistinctFromPredicate()) {
                        this.appendSql("exists (select cast(");
                        this.getClauseStack().push((Object)Clause.SELECT);
                        this.visitSqlSelectExpression(lhs);
                        this.appendSql(" as nvarchar(max))");
                        this.appendSql(this.getFromDualForSelectOnly());
                        this.appendSql(" intersect select cast(");
                        this.visitSqlSelectExpression(rhs);
                        this.appendSql(" as nvarchar(max))");
                        this.appendSql(this.getFromDualForSelectOnly());
                        this.getClauseStack().pop();
                        this.appendSql(')');
                        return;
                    }
                }
                case EQUAL: 
                case NOT_EQUAL: {
                    this.appendSql("cast(");
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(" as nvarchar(max))");
                    this.appendSql(operator.sqlText());
                    this.appendSql("cast(");
                    rhs.accept((SqlAstWalker)this);
                    this.appendSql(" as nvarchar(max))");
                    return;
                }
            }
        }
        if (this.getDialect().supportsDistinctFromPredicate()) {
            this.renderComparisonStandard(lhs, operator, rhs);
        } else {
            this.renderComparisonEmulateIntersect(lhs, operator, rhs);
        }
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("()");
        } else if (expression instanceof Summarization) {
            Summarization summarization = (Summarization)expression;
            this.renderCommaSeparated(summarization.getGroupings());
            this.appendSql(" with ");
            this.appendSql(summarization.getKind().sqlText());
        } else {
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        this.visitArithmeticOperand(arithmeticExpression.getLeftHandOperand());
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        this.visitArithmeticOperand(arithmeticExpression.getRightHandOperand());
        this.appendSql(')');
    }

    protected void renderStringContainsExactlyPredicate(Expression haystack, Expression needle) {
        this.appendSql("charindex(");
        needle.accept((SqlAstWalker)this);
        this.appendSql(" collate Latin1_General_100_BIN2,");
        haystack.accept((SqlAstWalker)this);
        this.append(")>0");
    }

    static enum OffsetFetchClauseMode {
        STANDARD,
        TOP_ONLY,
        EMULATED;

    }
}

