/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.community.dialect.MimerSQLSqlAstTranslator;
import org.hibernate.community.dialect.identity.MimerSQLIdentityColumnSupport;
import org.hibernate.community.dialect.sequence.MimerSequenceSupport;
import org.hibernate.community.dialect.sequence.SequenceInformationExtractorMimerSQLDatabaseImpl;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.SemanticException;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.internal.BinaryFloatDdlType;
import org.hibernate.type.descriptor.sql.internal.CapacityDependentDdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class MimerSQLDialect
extends Dialect {
    public MimerSQLDialect() {
        super(DatabaseVersion.make((Integer)11));
    }

    public MimerSQLDialect(DialectResolutionInfo info) {
        super(info);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case -6: {
                return "integer(3)";
            }
            case 2014: {
                return this.columnType(93);
            }
            case 1: {
                return this.columnType(-15);
            }
            case 12: {
                return this.columnType(-9);
            }
            case 4001: {
                return this.columnType(4002);
            }
            case 2004: {
                return "blob(2G)";
            }
            case 2005: 
            case 2011: {
                return "nclob(2G)";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected void registerColumnTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.registerColumnTypes(typeContributions, serviceRegistry);
        DdlTypeRegistry ddlTypeRegistry = typeContributions.getTypeConfiguration().getDdlTypeRegistry();
        ddlTypeRegistry.addDescriptor((DdlType)new BinaryFloatDdlType((Dialect)this));
        ddlTypeRegistry.addDescriptor((DdlType)CapacityDependentDdlType.builder((int)12, (CapacityDependentDdlType.LobKind)(this.isLob(4001) ? CapacityDependentDdlType.LobKind.BIGGEST_LOB : CapacityDependentDdlType.LobKind.NONE), (String)this.columnType(4001), (String)("nvarchar(" + this.getMaxNVarcharLength() + ")"), (Dialect)this).withTypeCapacity((long)this.getMaxNVarcharLength(), this.columnType(12)).build());
    }

    public int getMaxVarbinaryLength() {
        return 15000;
    }

    public int getMaxVarcharLength() {
        return 15000;
    }

    public int getMaxNVarcharLength() {
        return 5000;
    }

    public DatabaseVersion getVersion() {
        return SimpleDatabaseVersion.ZERO_VERSION;
    }

    public int getDefaultStatementBatchSize() {
        return 50;
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.soundex();
        functionFactory.octetLength();
        functionFactory.bitLength();
        functionFactory.trunc_truncate();
        functionFactory.repeat();
        functionFactory.pad_repeat();
        functionFactory.dayofweekmonthyear();
        functionFactory.concat_pipeOperator();
        functionFactory.position();
        functionFactory.localtimeLocaltimestamp();
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new MimerSQLSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String currentTimestamp() {
        return "localtimestamp";
    }

    public String currentTime() {
        return "localtime";
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week(?2)";
            }
            case DAY_OF_WEEK: {
                return "dayofweek(?2)";
            }
            case DAY_OF_YEAR: {
                return "dayofyear(?2)";
            }
            case DAY_OF_MONTH: {
                return "day(?2)";
            }
        }
        return super.extractPattern(unit);
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        pattern.append("cast((?3-?2) ");
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: 
            case SECOND: {
                pattern.append("second(12,9)");
                break;
            }
            case MINUTE: {
                pattern.append("minute(10)");
                break;
            }
            case HOUR: {
                pattern.append("hour(8)");
                break;
            }
            case WEEK: 
            case DAY: {
                pattern.append("day(7)");
                break;
            }
            case MONTH: 
            case QUARTER: {
                pattern.append("month(7)");
                break;
            }
            case YEAR: {
                pattern.append("year(7)");
                break;
            }
            default: {
                throw new SemanticException("unsupported duration unit: " + String.valueOf(unit));
            }
        }
        pattern.append(" as bigint)");
        switch (unit) {
            case WEEK: {
                pattern.append("/7");
                break;
            }
            case QUARTER: {
                pattern.append("/3");
                break;
            }
            case NATIVE: 
            case NANOSECOND: {
                pattern.append("*1e9");
            }
        }
        return pattern.toString();
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        switch (unit) {
            case NATIVE: 
            case NANOSECOND: {
                return "(?3+(?2)/1e9*interval '1' second)";
            }
            case QUARTER: {
                return "(?3+(?2)*interval '3' month)";
            }
            case WEEK: {
                return "(?3+(?2)*interval '7' day)";
            }
        }
        return "(?3+(?2)*interval '1' ?1)";
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getCascadeConstraintsString() {
        return " cascade";
    }

    public SequenceSupport getSequenceSupport() {
        return MimerSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select * from information_schema.ext_sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorMimerSQLDatabaseImpl.INSTANCE;
    }

    public LimitHandler getLimitHandler() {
        return OffsetFetchLimitHandler.INSTANCE;
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        throw new UnsupportedOperationException("format() function not supported on Mimer SQL");
    }

    public boolean useInputStreamToInsertBlob() {
        return false;
    }

    public boolean useConnectionToCreateLob() {
        return false;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return MimerSQLIdentityColumnSupport.INSTANCE;
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }
}

