/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.lang.invoke.MethodHandles;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.JDBCException;
import org.hibernate.LockMode;
import org.hibernate.StaleObjectStateException;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.community.dialect.HSQLLegacySqlAstTranslator;
import org.hibernate.community.dialect.pagination.LegacyHSQLLimitHandler;
import org.hibernate.dialect.BooleanDecoder;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DmlTargetColumnQualifierSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupport;
import org.hibernate.dialect.FunctionalDependencyAnalysisSupportImpl;
import org.hibernate.dialect.NullOrdering;
import org.hibernate.dialect.OracleDialect;
import org.hibernate.dialect.SimpleDatabaseVersion;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.function.TrimFunction;
import org.hibernate.dialect.identity.HSQLIdentityColumnSupport;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.PessimisticReadSelectLockingStrategy;
import org.hibernate.dialect.lock.PessimisticWriteSelectLockingStrategy;
import org.hibernate.dialect.lock.SelectLockingStrategy;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.pagination.OffsetFetchLimitHandler;
import org.hibernate.dialect.sequence.HSQLSequenceSupport;
import org.hibernate.dialect.sequence.SequenceSupport;
import org.hibernate.dialect.temptable.TemporaryTable;
import org.hibernate.dialect.temptable.TemporaryTableKind;
import org.hibernate.dialect.unique.CreateTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelper;
import org.hibernate.engine.jdbc.env.spi.IdentifierHelperBuilder;
import org.hibernate.engine.jdbc.env.spi.NameQualifierSupport;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.exception.ConstraintViolationException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.common.TemporalUnit;
import org.hibernate.query.sqm.CastType;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.function.SqmFunctionDescriptor;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.GlobalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableInsertStrategy;
import org.hibernate.query.sqm.mutation.internal.temptable.LocalTemporaryTableMutationStrategy;
import org.hibernate.query.sqm.mutation.spi.AfterUseAction;
import org.hibernate.query.sqm.mutation.spi.BeforeUseAction;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableInsertStrategy;
import org.hibernate.query.sqm.mutation.spi.SqmMultiTableMutationStrategy;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.tool.schema.extract.internal.SequenceInformationExtractorHSQLDBDatabaseImpl;
import org.hibernate.tool.schema.extract.spi.SequenceInformationExtractor;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class HSQLLegacyDialect
extends Dialect {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger((MethodHandles.Lookup)MethodHandles.lookup(), CoreMessageLogger.class, (String)HSQLLegacyDialect.class.getName());
    private final UniqueDelegate uniqueDelegate = new CreateTableUniqueDelegate((Dialect)this);
    private final HSQLIdentityColumnSupport identityColumnSupport = new HSQLIdentityColumnSupport(this.getVersion());
    private static final ViolatedConstraintNameExtractor EXTRACTOR_18 = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
            case -8: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Integrity constraint violation ", (String)" table:", (String)sqle.getMessage());
            }
            case -9: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Violation of unique index: ", (String)" in statement [", (String)sqle.getMessage());
            }
            case -104: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Unique constraint violation: ", (String)" in statement [", (String)sqle.getMessage());
            }
            case -177: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"Integrity constraint violation - no parent ", (String)" table:", (String)sqle.getMessage());
            }
        }
        return null;
    });
    private static final ViolatedConstraintNameExtractor EXTRACTOR_20 = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        switch (JdbcExceptionHelper.extractErrorCode((SQLException)sqle)) {
            case -177: 
            case -104: 
            case -9: 
            case -8: {
                return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"; ", (String)" table: ", (String)sqle.getMessage());
            }
        }
        return null;
    });

    public HSQLLegacyDialect(DialectResolutionInfo info) {
        super(info);
    }

    public HSQLLegacyDialect() {
        this(DatabaseVersion.make((Integer)1, (Integer)8));
    }

    public HSQLLegacyDialect(DatabaseVersion version) {
        super(version.isSame(1, 8) ? HSQLLegacyDialect.reflectedVersion(version) : version);
    }

    protected void registerDefaultKeywords() {
        super.registerDefaultKeywords();
        if (this.getVersion().isSameOrAfter(2, 5)) {
            this.registerKeyword("period");
        }
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 2011: {
                return "clob";
            }
        }
        if (this.getVersion().isBefore(2)) {
            switch (sqlTypeCode) {
                case 2: {
                    return "numeric";
                }
                case 2004: {
                    return "longvarbinary";
                }
                case 2005: {
                    return "longvarchar";
                }
            }
        }
        return super.columnType(sqlTypeCode);
    }

    protected Integer resolveSqlTypeCode(String typeName, String baseTypeName, TypeConfiguration typeConfiguration) {
        switch (baseTypeName) {
            case "DOUBLE": {
                return 8;
            }
        }
        return super.resolveSqlTypeCode(typeName, baseTypeName, typeConfiguration);
    }

    public int getDefaultStatementBatchSize() {
        return 15;
    }

    private static DatabaseVersion reflectedVersion(DatabaseVersion version) {
        try {
            Class props = ReflectHelper.classForName((String)"org.hsqldb.persist.HsqlDatabaseProperties");
            String versionString = (String)props.getDeclaredField("THIS_VERSION").get(null);
            return new SimpleDatabaseVersion(Integer.parseInt(versionString.substring(0, 1)), Integer.parseInt(versionString.substring(2, 3)), Integer.parseInt(versionString.substring(4, 5)));
        }
        catch (Throwable e) {
            return version;
        }
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.avg_castingNonDoubleArguments((Dialect)this, SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.cot();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.log10();
        functionFactory.rand();
        functionFactory.trunc_dateTrunc_trunc();
        functionFactory.pi();
        functionFactory.soundex();
        functionFactory.reverse();
        functionFactory.space();
        functionFactory.repeat();
        functionFactory.translate();
        functionFactory.bitand();
        functionFactory.bitor();
        functionFactory.bitxor();
        functionFactory.bitnot();
        functionFactory.yearMonthDay();
        functionFactory.hourMinuteSecond();
        functionFactory.dayofweekmonthyear();
        functionFactory.weekQuarter();
        functionFactory.daynameMonthname();
        functionFactory.lastDay();
        functionFactory.trim1();
        functionFactory.toCharNumberDateTimestamp();
        functionFactory.concat_pipeOperator();
        functionFactory.localtimeLocaltimestamp();
        functionFactory.bitLength();
        functionFactory.octetLength();
        functionFactory.ascii();
        functionFactory.chr_char();
        functionFactory.instr();
        functionFactory.substr();
        functionFactory.position();
        functionFactory.nowCurdateCurtime();
        functionFactory.insert();
        functionFactory.overlay();
        functionFactory.median();
        functionFactory.stddevPopSamp();
        functionFactory.varPopSamp();
        functionFactory.addMonths();
        functionFactory.monthsBetween();
        functionFactory.collate_quoted();
        if (this.getVersion().isSameOrAfter(2)) {
            functionFactory.sysdate();
        }
        if (this.getVersion().isSameOrAfter(2, 2)) {
            functionFactory.rownum();
        }
        functionFactory.listagg_groupConcat();
        functionFactory.array_hsql();
        functionFactory.arrayAggregate();
        functionFactory.arrayPosition_hsql();
        functionFactory.arrayPositions_hsql();
        functionFactory.arrayLength_cardinality();
        functionFactory.arrayConcat_operator();
        functionFactory.arrayPrepend_operator();
        functionFactory.arrayAppend_operator();
        functionFactory.arrayContains_hsql();
        functionFactory.arrayIntersects_hsql();
        functionFactory.arrayGet_unnest();
        functionFactory.arraySet_hsql();
        functionFactory.arrayRemove_hsql();
        functionFactory.arrayRemoveIndex_unnest(false);
        functionFactory.arraySlice_unnest();
        functionFactory.arrayReplace_unnest();
        functionFactory.arrayTrim_trim_array();
        functionFactory.arrayFill_hsql();
        functionFactory.arrayToString_hsql();
        if (this.getVersion().isSameOrAfter(2, 7)) {
            functionFactory.jsonObject_hsqldb();
            functionFactory.jsonArray_hsqldb();
            functionFactory.jsonArrayAgg_hsqldb();
            functionFactory.jsonObjectAgg_h2();
        }
        functionFactory.unnest("c1", "c2");
        functionFactory.generateSeries_recursive(this.getMaximumSeriesSize(), true, false);
        functionContributions.getFunctionRegistry().register("trim", (SqmFunctionDescriptor)new TrimFunction((Dialect)this, functionContributions.getTypeConfiguration(), SqlAstNodeRenderingMode.NO_PLAIN_PARAMETER));
    }

    protected int getMaximumSeriesSize() {
        return 258;
    }

    public @Nullable String getDefaultOrdinalityColumnName() {
        return "c2";
    }

    public String currentTime() {
        return "localtime";
    }

    public String currentTimestamp() {
        return "localtimestamp";
    }

    public String currentTimestampWithTimeZone() {
        return "current_timestamp";
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new HSQLLegacySqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public String castPattern(CastType from, CastType to) {
        switch (to) {
            case INTEGER: 
            case LONG: {
                String result = BooleanDecoder.toInteger((CastType)from);
                if (result == null) break;
                return result;
            }
            case BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("true", "false") : BooleanDecoder.toBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case INTEGER_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("1", "0") : BooleanDecoder.toIntegerBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case YN_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'Y'", "'N'") : BooleanDecoder.toYesNoBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case TF_BOOLEAN: {
                String result;
                String string = result = from == CastType.STRING ? this.buildStringToBooleanCastDecode("'T'", "'F'") : BooleanDecoder.toTrueFalseBoolean((CastType)from);
                if (result == null) break;
                return result;
            }
            case STRING: {
                String result = BooleanDecoder.toString((CastType)from);
                if (result == null) break;
                return "trim(" + result + ")";
            }
        }
        return super.castPattern(from, to);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castTo = temporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampadd(sql_tsi_frac_second,?2,");
                break;
            }
            case WEEK: {
                pattern.append("dateadd('day',?2*7,");
                break;
            }
            default: {
                pattern.append("dateadd('?1',?2,");
            }
        }
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        return pattern.toString();
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        boolean castFrom = fromTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        boolean castTo = toTemporalType != TemporalType.TIMESTAMP && !unit.isDateUnit();
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                pattern.append("timestampdiff(sql_tsi_frac_second");
                break;
            }
            case WEEK: {
                pattern.append("(datediff('day'");
            }
            default: {
                pattern.append("datediff('?1'");
            }
        }
        pattern.append(',');
        if (castFrom) {
            pattern.append("cast(?2 as timestamp)");
        } else {
            pattern.append("?2");
        }
        pattern.append(',');
        if (castTo) {
            pattern.append("cast(?3 as timestamp)");
        } else {
            pattern.append("?3");
        }
        pattern.append(")");
        if (unit == TemporalUnit.WEEK) {
            pattern.append("/7)");
        }
        return pattern.toString();
    }

    public boolean supportsDistinctFromPredicate() {
        return true;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public String getForUpdateString() {
        if (this.getVersion().isSameOrAfter(2)) {
            return " for update";
        }
        return "";
    }

    public LimitHandler getLimitHandler() {
        return this.getVersion().isBefore(2) ? LegacyHSQLLimitHandler.INSTANCE : (this.getVersion().isBefore(2, 5) ? LimitOffsetLimitHandler.OFFSET_ONLY_INSTANCE : OffsetFetchLimitHandler.INSTANCE);
    }

    public boolean supportsIfExistsAfterTableName() {
        return false;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean supportsColumnCheck() {
        return this.getVersion().isSameOrAfter(2);
    }

    public SequenceSupport getSequenceSupport() {
        return HSQLSequenceSupport.INSTANCE;
    }

    public String getQuerySequencesString() {
        return "select * from information_schema.sequences";
    }

    public SequenceInformationExtractor getSequenceInformationExtractor() {
        return SequenceInformationExtractorHSQLDBDatabaseImpl.INSTANCE;
    }

    public boolean supportsStandardArrays() {
        return true;
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return this.getVersion().isBefore(2) ? EXTRACTOR_18 : EXTRACTOR_20;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            switch (errorCode) {
                case -104: {
                    String constraintName = this.getViolatedConstraintNameExtractor().extractConstraintName(sqlException);
                    return new ConstraintViolationException(message, sqlException, sql, ConstraintViolationException.ConstraintKind.UNIQUE, constraintName);
                }
            }
            return null;
        };
    }

    public String getSelectClauseNullString(int sqlType, TypeConfiguration typeConfiguration) {
        return switch (sqlType) {
            case -1, 1, 12 -> "cast(null as varchar(100))";
            case -4, -3, -2 -> "cast(null as varbinary(100))";
            case 2005 -> "cast(null as clob)";
            case 2004 -> "cast(null as blob)";
            case 91 -> "cast(null as date)";
            case 93, 2014 -> "cast(null as timestamp)";
            case 16 -> "cast(null as boolean)";
            case -7 -> "cast(null as bit)";
            case 92 -> "cast(null as time)";
            default -> "cast(null as int)";
        };
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.FIRST;
    }

    public SqmMultiTableMutationStrategy getFallbackSqmMutationStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        if (this.getVersion().isBefore(2)) {
            return new GlobalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
        }
        return new LocalTemporaryTableMutationStrategy(TemporaryTable.createIdTable((EntityMappingType)rootEntityDescriptor, basename -> "MODULE.HT_" + basename, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public SqmMultiTableInsertStrategy getFallbackSqmInsertStrategy(EntityMappingType rootEntityDescriptor, RuntimeModelCreationContext runtimeModelCreationContext) {
        if (this.getVersion().isBefore(2)) {
            return new GlobalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
        }
        return new LocalTemporaryTableInsertStrategy(TemporaryTable.createEntityTable((EntityMappingType)rootEntityDescriptor, name -> "MODULE.HTE_" + name, (Dialect)this, (RuntimeModelCreationContext)runtimeModelCreationContext), runtimeModelCreationContext.getSessionFactory());
    }

    public TemporaryTableKind getSupportedTemporaryTableKind() {
        return this.getVersion().isBefore(2) ? TemporaryTableKind.GLOBAL : TemporaryTableKind.LOCAL;
    }

    public String getTemporaryTableCreateCommand() {
        return this.getVersion().isBefore(2) ? super.getTemporaryTableCreateCommand() : "declare local temporary table";
    }

    public AfterUseAction getTemporaryTableAfterUseAction() {
        return this.getVersion().isBefore(2) ? AfterUseAction.CLEAN : AfterUseAction.DROP;
    }

    public BeforeUseAction getTemporaryTableBeforeUseAction() {
        return this.getVersion().isBefore(2) ? BeforeUseAction.NONE : BeforeUseAction.CREATE;
    }

    public boolean supportsCurrentTimestampSelection() {
        return true;
    }

    public boolean isCurrentTimestampSelectStringCallable() {
        return false;
    }

    public String getCurrentTimestampSelectString() {
        return "call current_timestamp";
    }

    public boolean doesRoundTemporalOnOverflow() {
        return false;
    }

    public LockingStrategy getLockingStrategy(EntityPersister lockable, LockMode lockMode) {
        switch (lockMode) {
            case PESSIMISTIC_FORCE_INCREMENT: {
                return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_WRITE: {
                return new PessimisticWriteSelectLockingStrategy(lockable, lockMode);
            }
            case PESSIMISTIC_READ: {
                return new PessimisticReadSelectLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC: {
                return new OptimisticLockingStrategy(lockable, lockMode);
            }
            case OPTIMISTIC_FORCE_INCREMENT: {
                return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
            }
        }
        if (this.getVersion().isBefore(2)) {
            return new ReadUncommittedLockingStrategy(lockable, lockMode);
        }
        return new SelectLockingStrategy(lockable, lockMode);
    }

    public boolean supportsCommentOn() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return this.getVersion().isSameOrAfter(2);
    }

    public boolean supportsLobValueChangePropagation() {
        return false;
    }

    public void appendBooleanValueString(SqlAppender appender, boolean bool) {
        appender.appendSql(bool);
    }

    public boolean supportsTupleCounts() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return this.getVersion().isSameOrAfter(2, 2, 9);
    }

    public boolean supportsOffsetInSubquery() {
        return true;
    }

    public boolean supportsLateral() {
        return this.getVersion().isSameOrAfter(2, 6, 1);
    }

    public boolean requiresFloatCastingOfIntegerDivision() {
        return true;
    }

    public boolean supportsValuesList() {
        return true;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return this.identityColumnSupport;
    }

    public NameQualifierSupport getNameQualifierSupport() {
        return NameQualifierSupport.SCHEMA;
    }

    public boolean supportsNamedParameters(DatabaseMetaData databaseMetaData) {
        return false;
    }

    public FunctionalDependencyAnalysisSupport getFunctionalDependencyAnalysisSupport() {
        return FunctionalDependencyAnalysisSupportImpl.TABLE_REFERENCE;
    }

    public boolean dropConstraints() {
        return false;
    }

    public String getCascadeConstraintsString() {
        return " cascade ";
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(OracleDialect.datetimeFormat((String)format, (boolean)false, (boolean)false).replace("MMMM", "MONTH").replace("EEEE", "DAY").replace("SSSSSS", "FF").replace("SSSSS", "FF").replace("SSSS", "FF").replace("SSS", "FF").replace("SS", "FF").replace("S", "FF").result());
    }

    public String translateExtractField(TemporalUnit unit) {
        switch (unit) {
            case WEEK: {
                return "week_of_year";
            }
        }
        return unit.toString();
    }

    public IdentifierHelper buildIdentifierHelper(IdentifierHelperBuilder builder, DatabaseMetaData dbMetaData) throws SQLException {
        builder.setAutoQuoteInitialUnderscore(true);
        builder.setAutoQuoteDollar(true);
        return super.buildIdentifierHelper(builder, dbMetaData);
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public DmlTargetColumnQualifierSupport getDmlTargetColumnQualifierSupport() {
        return DmlTargetColumnQualifierSupport.TABLE_ALIAS;
    }

    public String getFromDualForSelectOnly() {
        return " from " + this.getDual();
    }

    public boolean supportsFilterClause() {
        return true;
    }

    public boolean supportsArrayConstructor() {
        return true;
    }

    public boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    public boolean supportsWithClauseInSubquery() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    public boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    private static class ReadUncommittedLockingStrategy
    extends SelectLockingStrategy {
        private ReadUncommittedLockingStrategy(EntityPersister lockable, LockMode lockMode) {
            super(lockable, lockMode);
        }

        public void lock(Object id, Object version, Object object, int timeout, SharedSessionContractImplementor session) throws StaleObjectStateException, JDBCException {
            if (this.getLockMode().greaterThan(LockMode.READ)) {
                LOG.hsqldbSupportsOnlyReadCommittedIsolation();
            }
            super.lock(id, version, object, timeout, session);
        }
    }
}

