/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.annotationfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationProxy;
import org.hibernate.validator.internal.util.privilegedactions.ConstructorInstance;
import org.hibernate.validator.internal.util.privilegedactions.GetClassLoader;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredConstructor;

public class AnnotationFactory {
    public static <T extends Annotation> T create(AnnotationDescriptor<T> descriptor) {
        Class<?> proxyClass = Proxy.getProxyClass(AnnotationFactory.run(GetClassLoader.fromClass(descriptor.type())), descriptor.type());
        AnnotationProxy handler = new AnnotationProxy(descriptor);
        try {
            return (T)AnnotationFactory.getProxyInstance(proxyClass, handler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static <T extends Annotation> T getProxyInstance(Class<T> proxyClass, InvocationHandler handler) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = (Constructor)AnnotationFactory.run(GetDeclaredConstructor.action(proxyClass, InvocationHandler.class));
        return (T)((Annotation)AnnotationFactory.run(ConstructorInstance.action(constructor, handler)));
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

