/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cfg.context.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Map;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.metadata.location.BeanConstraintLocation;
import org.hibernate.validator.metadata.location.ConstraintLocation;
import org.hibernate.validator.metadata.location.MethodConstraintLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredConstraint<A extends Annotation, L extends ConstraintLocation> {
    private final ConstraintDefAccessor<A> constraint;
    private final L location;

    private ConfiguredConstraint(ConstraintDef<?, A> constraint, L location) {
        this.constraint = new ConstraintDefAccessor(constraint);
        this.location = location;
    }

    public static <A extends Annotation> ConfiguredConstraint<A, BeanConstraintLocation> forType(ConstraintDef<?, A> constraint, Class<?> beanType) {
        return new ConfiguredConstraint<A, BeanConstraintLocation>(constraint, new BeanConstraintLocation(beanType));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, BeanConstraintLocation> forProperty(ConstraintDef<?, A> constraint, Class<?> beanType, Member member) {
        return new ConfiguredConstraint<A, BeanConstraintLocation>(constraint, new BeanConstraintLocation(beanType, member));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, MethodConstraintLocation> forParameter(ConstraintDef<?, A> constraint, Method method, int parameterIndex) {
        return new ConfiguredConstraint<A, MethodConstraintLocation>(constraint, new MethodConstraintLocation(method, parameterIndex));
    }

    public static <A extends Annotation> ConfiguredConstraint<A, MethodConstraintLocation> forReturnValue(ConstraintDef<?, A> constraint, Method method) {
        return new ConfiguredConstraint<A, MethodConstraintLocation>(constraint, new MethodConstraintLocation(method));
    }

    public ConstraintDef<?, A> getConstraint() {
        return this.constraint;
    }

    public L getLocation() {
        return this.location;
    }

    public Class<A> getConstraintType() {
        return ((ConstraintDefAccessor)this.constraint).getConstraintType();
    }

    public Map<String, Object> getParameters() {
        return ((ConstraintDefAccessor)this.constraint).getParameters();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConstraintDefAccessor<A extends Annotation>
    extends ConstraintDef<ConstraintDefAccessor<A>, A> {
        private ConstraintDefAccessor(ConstraintDef<?, A> original) {
            super(original);
        }

        private Class<A> getConstraintType() {
            return this.constraintType;
        }

        private Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

