/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.orm.junit;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.Transaction;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.testing.jdbc.SharedDriverManagerConnectionProviderImpl;
import org.hibernate.testing.orm.junit.DialectContext;
import org.hibernate.testing.orm.junit.DomainModelProducer;
import org.hibernate.testing.orm.junit.DomainModelScope;
import org.hibernate.testing.orm.junit.DomainModelScopeAware;
import org.hibernate.testing.orm.junit.ServiceRegistryProducer;
import org.hibernate.testing.orm.junit.ServiceRegistryScope;
import org.hibernate.testing.orm.junit.ServiceRegistryScopeAware;
import org.hibernate.testing.orm.junit.SessionFactoryFunctionalTesting;
import org.hibernate.testing.orm.junit.SessionFactoryProducer;
import org.hibernate.testing.orm.junit.SessionFactoryScope;
import org.hibernate.testing.orm.junit.SessionFactoryScopeAware;
import org.hibernate.testing.transaction.TransactionUtil;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.AfterEach;

@SessionFactoryFunctionalTesting
public abstract class BaseSessionFactoryFunctionalTest
implements ServiceRegistryProducer,
ServiceRegistryScopeAware,
DomainModelProducer,
DomainModelScopeAware,
SessionFactoryProducer,
SessionFactoryScopeAware {
    protected static final Dialect DIALECT = DialectContext.getDialect();
    protected static final Class[] NO_CLASSES = new Class[0];
    protected static final String[] NO_MAPPINGS = new String[0];
    private static final Logger log = Logger.getLogger(BaseSessionFactoryFunctionalTest.class);
    private ServiceRegistryScope registryScope;
    private DomainModelScope modelScope;
    private SessionFactoryScope sessionFactoryScope;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    protected SessionFactoryScope sessionFactoryScope() {
        return this.sessionFactoryScope;
    }

    protected SessionFactoryImplementor sessionFactory() {
        return this.sessionFactoryScope.getSessionFactory();
    }

    protected MetadataImplementor getMetadata() {
        return this.modelScope.getDomainModel();
    }

    @Override
    public StandardServiceRegistry produceServiceRegistry(StandardServiceRegistryBuilder ssrBuilder) {
        ssrBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)(this.exportSchema() ? "create-drop" : "none"));
        if (!Environment.getProperties().containsKey("hibernate.connection.provider_class")) {
            ssrBuilder.applySetting("hibernate.connection.provider_class", (Object)SharedDriverManagerConnectionProviderImpl.getInstance());
        }
        this.applySettings(ssrBuilder);
        return ssrBuilder.build();
    }

    @Override
    public void prepareBootstrapRegistryBuilder(BootstrapServiceRegistryBuilder bsrb) {
    }

    protected boolean exportSchema() {
        return true;
    }

    protected void applySettings(StandardServiceRegistryBuilder builder) {
    }

    @Override
    public void injectServiceRegistryScope(ServiceRegistryScope registryScope) {
        this.registryScope = registryScope;
    }

    @Override
    public MetadataImplementor produceModel(StandardServiceRegistry serviceRegistry) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        this.applyMetadataBuilder(metadataBuilder);
        this.applyMetadataSources(metadataSources);
        MetadataImplementor metadata = (MetadataImplementor)metadataBuilder.build();
        if (!this.overrideCacheStrategy() || this.getCacheConcurrencyStrategy() == null) {
            return metadata;
        }
        this.applyCacheSettings((Metadata)metadata);
        return metadata;
    }

    protected final void applyCacheSettings(Metadata metadata) {
        for (PersistentClass entityBinding : metadata.getEntityBindings()) {
            if (entityBinding.isInherited()) continue;
            boolean hasLob = false;
            Iterator props = entityBinding.getPropertyClosureIterator();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                if (!prop.getValue().isSimpleValue() || !BaseSessionFactoryFunctionalTest.isLob((SimpleValue)prop.getValue())) continue;
                hasLob = true;
                break;
            }
            if (hasLob) continue;
            ((RootClass)entityBinding).setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
            entityBinding.setCached(true);
        }
        for (Collection collectionBinding : metadata.getCollectionBindings()) {
            boolean isLob = false;
            if (collectionBinding.getElement().isSimpleValue()) {
                isLob = BaseSessionFactoryFunctionalTest.isLob((SimpleValue)collectionBinding.getElement());
            }
            if (isLob) continue;
            collectionBinding.setCacheConcurrencyStrategy(this.getCacheConcurrencyStrategy());
        }
    }

    protected boolean overrideCacheStrategy() {
        return true;
    }

    protected String getCacheConcurrencyStrategy() {
        return null;
    }

    protected void applyMetadataBuilder(MetadataBuilder metadataBuilder) {
    }

    protected void applyMetadataSources(MetadataSources metadataSources) {
        for (Class annotatedClass : this.getAnnotatedClasses()) {
            metadataSources.addAnnotatedClass(annotatedClass);
        }
        String[] xmlFiles = this.getOrmXmlFiles();
        if (xmlFiles != null) {
            for (String xmlFile : xmlFiles) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(xmlFile);){
                    metadataSources.addInputStream(is);
                }
                catch (IOException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    protected Class[] getAnnotatedClasses() {
        return NO_CLASSES;
    }

    protected String[] getOrmXmlFiles() {
        return NO_MAPPINGS;
    }

    @Override
    public void injectTestModelScope(DomainModelScope modelScope) {
        this.modelScope = modelScope;
    }

    @Override
    public SessionFactoryImplementor produceSessionFactory(MetadataImplementor model) {
        log.trace((Object)"Producing SessionFactory");
        SessionFactoryBuilder sfBuilder = model.getSessionFactoryBuilder();
        this.configure(sfBuilder);
        SessionFactoryImplementor factory = (SessionFactoryImplementor)sfBuilder.build();
        this.sessionFactoryBuilt(factory);
        return factory;
    }

    protected void configure(SessionFactoryBuilder builder) {
    }

    protected void sessionFactoryBuilt(SessionFactoryImplementor factory) {
    }

    @Override
    public void injectSessionFactoryScope(SessionFactoryScope scope) {
        this.sessionFactoryScope = scope;
    }

    @AfterEach
    public final void afterTest() {
        if (this.isCleanupTestDataRequired()) {
            this.cleanupTestData();
        }
    }

    protected boolean isCleanupTestDataRequired() {
        return false;
    }

    protected void cleanupTestData() {
        this.inTransaction(session -> this.getMetadata().getEntityBindings().forEach(entityType -> session.createQuery("delete from " + entityType.getEntityName()).executeUpdate()));
    }

    protected void inTransaction(Consumer<SessionImplementor> action) {
        this.sessionFactoryScope().inTransaction(action);
    }

    protected <T> T fromTransaction(Function<SessionImplementor, T> action) {
        return this.sessionFactoryScope().fromTransaction(action);
    }

    protected void inSession(Consumer<SessionImplementor> action) {
        this.sessionFactoryScope.inSession(action);
    }

    protected <T> T fromSession(Function<SessionImplementor, T> action) {
        return this.sessionFactoryScope.fromSession(action);
    }

    protected Dialect getDialect() {
        return DialectContext.getDialect();
    }

    private static boolean isLob(SimpleValue value) {
        String typeName = value.getTypeName();
        if (typeName != null) {
            String significantTypeNamePart;
            switch (significantTypeNamePart = typeName.substring(typeName.lastIndexOf(46) + 1).toLowerCase(Locale.ROOT)) {
                case "blob": 
                case "blobtype": 
                case "clob": 
                case "clobtype": 
                case "nclob": 
                case "nclobtype": {
                    return true;
                }
            }
        }
        return false;
    }

    protected Future<?> executeAsync(Runnable callable) {
        return this.executorService.submit(callable);
    }

    protected void executeSync(Runnable callable) {
        try {
            this.executeAsync(callable).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    public static void doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, TransactionUtil.HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }
}

