/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.transaction;

import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import org.hibernate.Session;
import org.hibernate.SessionBuilder;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.dialect.AbstractHANADialect;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.H2Dialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.PostgreSQL81Dialect;
import org.hibernate.dialect.SQLServerDialect;
import org.jboss.logging.Logger;

public class TransactionUtil {
    private static final Logger log = Logger.getLogger(TransactionUtil.class);

    public static <T> T doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionFunction<T> function, Map properties) {
        T result = null;
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = properties == null ? factorySupplier.get().createEntityManager() : factorySupplier.get().createEntityManager(properties);
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            result = (T)function.apply(entityManager);
            txn.commit();
        }
        catch (Throwable e) {
            if (txn != null && txn.isActive()) {
                txn.rollback();
            }
            throw e;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
        return result;
    }

    public static <T> T doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionFunction<T> function) {
        return TransactionUtil.doInJPA(factorySupplier, function, null);
    }

    public static void doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionVoidFunction function, Map properties) {
        EntityManager entityManager = null;
        EntityTransaction txn = null;
        try {
            entityManager = properties == null ? factorySupplier.get().createEntityManager() : factorySupplier.get().createEntityManager(properties);
            function.beforeTransactionCompletion();
            txn = entityManager.getTransaction();
            txn.begin();
            function.accept(entityManager);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (entityManager != null) {
                entityManager.close();
            }
        }
    }

    public static void doInJPA(Supplier<EntityManagerFactory> factorySupplier, JPATransactionVoidFunction function) {
        TransactionUtil.doInJPA(factorySupplier, function, null);
    }

    public static <T> T doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = factorySupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    public static void doInHibernate(Supplier<SessionFactory> factorySupplier, String tenant, Consumer<Session> function) {
        Transaction txn = null;
        try (Session session = null;){
            session = factorySupplier.get().withOptions().tenantIdentifier(tenant).openSession();
            txn = session.getTransaction();
            txn.begin();
            function.accept(session);
            txn.commit();
        }
    }

    public static <R> R doInHibernate(Supplier<SessionFactory> factorySupplier, String tenant, Function<Session, R> function) {
        Transaction txn = null;
        try (Session session = null;){
            session = factorySupplier.get().withOptions().tenantIdentifier(tenant).openSession();
            txn = session.getTransaction();
            txn.begin();
            R returnValue = function.apply(session);
            txn.commit();
            R r = returnValue;
            return r;
        }
    }

    public static <T> T doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionFunction<T> function) {
        T result = null;
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            result = (T)function.apply(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
        return result;
    }

    public static void doInHibernateSessionBuilder(Supplier<SessionBuilder> sessionBuilderSupplier, HibernateTransactionConsumer function) {
        Session session = null;
        Transaction txn = null;
        try {
            session = sessionBuilderSupplier.get().openSession();
            function.beforeTransactionCompletion();
            txn = session.beginTransaction();
            function.accept(session);
            if (!txn.getRollbackOnly()) {
                txn.commit();
            } else {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            if (txn != null && txn.isActive()) {
                try {
                    txn.rollback();
                }
                catch (Exception e) {
                    log.error((Object)"Rollback failure", (Throwable)e);
                }
            }
            throw t;
        }
        finally {
            function.afterTransactionCompletion();
            if (session != null) {
                session.close();
            }
        }
    }

    public static void setJdbcTimeout(Session session) {
        TransactionUtil.setJdbcTimeout(session, TimeUnit.SECONDS.toMillis(1L));
    }

    public static void setJdbcTimeout(Session session, long millis) {
        session.doWork(connection -> {
            if (Dialect.getDialect() instanceof PostgreSQL81Dialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET statement_timeout TO %d", millis / 10L));
                }
            }
            if (Dialect.getDialect() instanceof MySQLDialect) {
                try (PreparedStatement st = connection.prepareStatement("SET SESSION innodb_lock_wait_timeout = ?");){
                    st.setLong(1, TimeUnit.MILLISECONDS.toSeconds(millis));
                    st.execute();
                }
            }
            if (Dialect.getDialect() instanceof H2Dialect) {
                try (PreparedStatement st = connection.prepareStatement("SET LOCK_TIMEOUT ?");){
                    st.setLong(1, millis / 10L);
                    st.execute();
                }
            }
            if (Dialect.getDialect() instanceof SQLServerDialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET LOCK_TIMEOUT %d", millis / 10L));
                }
            }
            if (Dialect.getDialect() instanceof AbstractHANADialect) {
                try (Statement st = connection.createStatement();){
                    st.execute(String.format("SET TRANSACTION LOCK WAIT TIMEOUT %d", millis));
                }
            }
            try {
                connection.setNetworkTimeout(Executors.newSingleThreadExecutor(), (int)millis);
            }
            catch (Throwable ignore) {
                ignore.fillInStackTrace();
            }
        });
    }

    @FunctionalInterface
    public static interface JPATransactionVoidFunction
    extends Consumer<EntityManager> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface JPATransactionFunction<T>
    extends Function<EntityManager, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionConsumer
    extends Consumer<Session> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }

    @FunctionalInterface
    public static interface HibernateTransactionFunction<T>
    extends Function<Session, T> {
        default public void beforeTransactionCompletion() {
        }

        default public void afterTransactionCompletion() {
        }
    }
}

