/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.bytecode.enhancement;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.LoaderClassPath;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.internal.MutableEntityEntryFactory;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SelfDirtinessTracker;
import org.hibernate.engine.spi.Status;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.testing.bytecode.enhancement.DecompileUtils;
import org.hibernate.testing.bytecode.enhancement.EnhancerTestContext;
import org.hibernate.testing.bytecode.enhancement.EnhancerTestTask;
import org.hibernate.testing.junit4.BaseUnitTestCase;
import org.junit.Assert;

public abstract class EnhancerTestUtils
extends BaseUnitTestCase {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(EnhancerTestUtils.class);
    private static String workingDir = System.getProperty("java.io.tmpdir");

    public static Class<?> enhanceAndDecompile(Class<?> classToEnhance, ClassLoader cl) throws Exception {
        CtClass entityCtClass = EnhancerTestUtils.generateCtClassForAnEntity(classToEnhance);
        byte[] original = entityCtClass.toBytecode();
        byte[] enhanced = new Enhancer((EnhancementContext)new EnhancerTestContext()).enhance(entityCtClass.getName(), original);
        Assert.assertFalse((String)"entity was not enhanced", (boolean)Arrays.equals(original, enhanced));
        log.infof("enhanced entity [%s]", (Object)entityCtClass.getName());
        ClassPool cp = new ClassPool(false);
        cp.appendClassPath((ClassPath)new LoaderClassPath(cl));
        CtClass enhancedCtClass = cp.makeClass((InputStream)new ByteArrayInputStream(enhanced));
        enhancedCtClass.debugWriteFile(workingDir);
        DecompileUtils.decompileDumpedClass(workingDir, classToEnhance.getName());
        Class enhancedClass = enhancedCtClass.toClass(cl, EnhancerTestUtils.class.getProtectionDomain());
        Assert.assertNotNull((Object)enhancedClass);
        return enhancedClass;
    }

    private static CtClass generateCtClassForAnEntity(Class<?> entityClassToEnhance) throws Exception {
        ClassPool cp = new ClassPool(false);
        ClassLoader cl = EnhancerTestUtils.class.getClassLoader();
        return cp.makeClass(cl.getResourceAsStream(entityClassToEnhance.getName().replace('.', '/') + ".class"));
    }

    public static <T extends EnhancerTestTask> void runEnhancerTestTask(Class<T> task) {
        EnhancerTestUtils.runEnhancerTestTask(task, (EnhancementContext)new EnhancerTestContext());
    }

    public static <T extends EnhancerTestTask> void runEnhancerTestTask(Class<T> task, EnhancementContext context) {
        EnhancerTestTask taskObject = null;
        ClassLoader defaultCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = EnhancerTestUtils.getEnhancerClassLoader(context, task.getPackage().getName());
            EnhancerTestUtils.setupClassLoader(cl, task);
            EnhancerTestUtils.setupClassLoader(cl, ((EnhancerTestTask)task.newInstance()).getAnnotatedClasses());
            Thread.currentThread().setContextClassLoader(cl);
            taskObject = cl.loadClass(task.getName()).asSubclass(EnhancerTestTask.class).newInstance();
            taskObject.prepare();
            taskObject.execute();
        }
        catch (Exception e) {
            throw new HibernateException("could not execute task", (Throwable)e);
        }
        finally {
            try {
                if (taskObject != null) {
                    taskObject.complete();
                }
            }
            catch (Throwable throwable) {}
            Thread.currentThread().setContextClassLoader(defaultCL);
        }
    }

    private static void setupClassLoader(ClassLoader cl, Class<?> ... classesToLoad) {
        for (Class<?> classToLoad : classesToLoad) {
            try {
                cl.loadClass(classToLoad.getName());
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private static ClassLoader getEnhancerClassLoader(final EnhancementContext context, final String packageName) {
        return new ClassLoader(){
            private Enhancer enhancer;
            {
                this.enhancer = new Enhancer(context);
            }

            @Override
            public Class<?> loadClass(String name) throws ClassNotFoundException {
                if (!name.startsWith(packageName)) {
                    return this.getParent().loadClass(name);
                }
                Class<?> c = this.findLoadedClass(name);
                if (c != null) {
                    return c;
                }
                InputStream is = this.getResourceAsStream(name.replace('.', '/') + ".class");
                if (is == null) {
                    throw new ClassNotFoundException(name + " not found");
                }
                try {
                    byte[] original = new byte[is.available()];
                    new BufferedInputStream(is).read(original);
                    byte[] enhanced = this.enhancer.enhance(name, original);
                    File f = new File(workingDir + File.separator + name.replace(".", File.separator) + ".class");
                    f.getParentFile().mkdirs();
                    f.createNewFile();
                    FileOutputStream out = new FileOutputStream(f);
                    out.write(enhanced);
                    out.close();
                    Class<?> clazz = this.defineClass(name, enhanced, 0, enhanced.length);
                    return clazz;
                }
                catch (Throwable t) {
                    throw new ClassNotFoundException(name + " not found", t);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        };
    }

    public static Object getFieldByReflection(Object entity, String fieldName) {
        try {
            Field field = entity.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(entity);
        }
        catch (NoSuchFieldException e) {
            Assert.fail((String)("Fail to get field '" + fieldName + "' in entity " + entity));
        }
        catch (IllegalAccessException e) {
            Assert.fail((String)("Fail to get field '" + fieldName + "' in entity " + entity));
        }
        return null;
    }

    public static void clearDirtyTracking(Object entityInstance) {
        ((SelfDirtinessTracker)entityInstance).$$_hibernate_clearDirtyAttributes();
    }

    public static void checkDirtyTracking(Object entityInstance, String ... dirtyFields) {
        SelfDirtinessTracker selfDirtinessTracker = (SelfDirtinessTracker)entityInstance;
        Assert.assertEquals((Object)(dirtyFields.length > 0 ? 1 : 0), (Object)selfDirtinessTracker.$$_hibernate_hasDirtyAttributes());
        String[] tracked = selfDirtinessTracker.$$_hibernate_getDirtyAttributes();
        Assert.assertEquals((long)dirtyFields.length, (long)tracked.length);
        Assert.assertTrue((boolean)Arrays.asList(tracked).containsAll(Arrays.asList(dirtyFields)));
    }

    public static EntityEntry makeEntityEntry() {
        return MutableEntityEntryFactory.INSTANCE.createEntityEntry(Status.MANAGED, null, null, (Serializable)Integer.valueOf(1), null, LockMode.NONE, false, null, false, null);
    }
}

