/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.async;

import org.hibernate.testing.async.Executable;

public class ExecutableAdapter
implements Runnable {
    private final Executable executable;
    private boolean isDone;
    private Throwable error;

    public ExecutableAdapter(Executable executable) {
        this.executable = executable;
    }

    public boolean isDone() {
        return this.isDone;
    }

    public void reThrowAnyErrors() {
        if (this.error != null) {
            if (RuntimeException.class.isInstance(this.error)) {
                throw (RuntimeException)RuntimeException.class.cast(this.error);
            }
            if (Error.class.isInstance(this.error)) {
                throw (Error)Error.class.cast(this.error);
            }
            throw new ExceptionWrapper(this.error);
        }
    }

    @Override
    public void run() {
        this.isDone = false;
        this.error = null;
        try {
            this.executable.execute();
        }
        catch (Throwable t) {
            this.error = t;
        }
        finally {
            this.isDone = true;
        }
    }

    public static class ExceptionWrapper
    extends RuntimeException {
        public ExceptionWrapper(Throwable cause) {
            super(cause);
        }
    }
}

