/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
public @interface Skip {
    public Class<? extends Matcher> condition();

    public String message();

    public static interface OperatingSystem {

        public static class Windows
        implements Matcher {
            @Override
            public boolean isMatch() {
                return System.getProperty("os.name").toLowerCase().contains("windows");
            }
        }
    }

    public static class AlwaysSkip
    implements Matcher {
        @Override
        public boolean isMatch() {
            return true;
        }
    }

    public static interface Matcher {
        public boolean isMatch();
    }
}

