/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;

public class ScopedAnalyzer
extends Analyzer {
    private Analyzer globalAnalyzer;
    private Map<String, Analyzer> scopedAnalyzers = new HashMap<String, Analyzer>();

    public void setGlobalAnalyzer(Analyzer globalAnalyzer) {
        this.globalAnalyzer = globalAnalyzer;
    }

    public void addScopedAnalyzer(String scope, Analyzer scopedAnalyzer) {
        this.scopedAnalyzers.put(scope, scopedAnalyzer);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return this.getAnalyzer(fieldName).tokenStream(fieldName, reader);
    }

    public int getPositionIncrementGap(String fieldName) {
        return this.getAnalyzer(fieldName).getPositionIncrementGap(fieldName);
    }

    private Analyzer getAnalyzer(String fieldName) {
        Analyzer analyzer = this.scopedAnalyzers.get(fieldName);
        if (analyzer == null) {
            analyzer = this.globalAnalyzer;
        }
        return analyzer;
    }
}

