/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.jpa.event.spi.jpa.Callback;

public class EntityCallback
implements Callback {
    private Method callbackMethod;

    public EntityCallback(Method callbackMethod) {
        this.callbackMethod = callbackMethod;
    }

    @Override
    public boolean performCallback(Object entity) {
        try {
            this.callbackMethod.invoke(entity, new Object[0]);
            return true;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw new RuntimeException(e.getTargetException());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isActive() {
        return true;
    }
}

