/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.AuxiliaryDatabaseObject;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.Sequence;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class SchemaDropperImpl
implements SchemaDropper {
    public Iterable<String> generateDropCommands(MetadataImplementor metadata, boolean dropNamespaces, Dialect dialect) {
        final ArrayList<String> commands = new ArrayList<String>();
        this.doDrop((Metadata)metadata, dropNamespaces, dialect, new Target(){

            @Override
            public boolean acceptsImportScriptActions() {
                return true;
            }

            @Override
            public void prepare() {
            }

            @Override
            public void accept(String action) {
                commands.add(action);
            }

            @Override
            public void release() {
            }
        });
        return commands;
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropNamespaces, List<Target> targets) throws SchemaManagementException {
        this.doDrop(metadata, dropNamespaces, targets.toArray(new Target[targets.size()]));
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropNamespaces, Dialect dialect, List<Target> targets) throws SchemaManagementException {
        this.doDrop(metadata, dropNamespaces, dialect, targets.toArray(new Target[targets.size()]));
    }

    @Override
    public void doDrop(Metadata metadata, boolean dropNamespaces, Target ... targets) throws SchemaManagementException {
        this.doDrop(metadata, dropNamespaces, metadata.getDatabase().getJdbcEnvironment().getDialect(), targets);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doDrop(Metadata metadata, boolean dropNamespaces, Dialect dialect, Target ... targets) throws SchemaManagementException {
        void var12_24;
        Database database = metadata.getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        boolean tryToDropCatalogs = false;
        boolean tryToDropSchemas = false;
        if (dropNamespaces) {
            if (dialect.canCreateSchema()) {
                tryToDropSchemas = true;
            }
            if (dialect.canCreateCatalog()) {
                tryToDropCatalogs = true;
            }
        }
        for (Target target : targets) {
            target.prepare();
        }
        HashSet<String> exportIdentifiers = new HashSet<String>(50);
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (!auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(targets, dialect.getAuxiliaryDatabaseObjectExporter().getSqlDropStrings(auxiliaryDatabaseObject, metadata));
        }
        for (Namespace namespace : database.getNamespaces()) {
            this.applyConstraintDropping(targets, namespace, metadata);
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable()) continue;
                SchemaDropperImpl.checkExportIdentifier(table, exportIdentifiers);
                SchemaDropperImpl.applySqlStrings(targets, dialect.getTableExporter().getSqlDropStrings(table, metadata));
            }
            for (Sequence sequence : namespace.getSequences()) {
                SchemaDropperImpl.checkExportIdentifier(sequence, exportIdentifiers);
                SchemaDropperImpl.applySqlStrings(targets, dialect.getSequenceExporter().getSqlDropStrings(sequence, metadata));
            }
        }
        for (AuxiliaryDatabaseObject auxiliaryDatabaseObject : database.getAuxiliaryDatabaseObjects()) {
            if (auxiliaryDatabaseObject.beforeTablesOnCreation() || !auxiliaryDatabaseObject.appliesToDialect(dialect)) continue;
            SchemaDropperImpl.applySqlStrings(targets, auxiliaryDatabaseObject.sqlDropStrings(jdbcEnvironment.getDialect()));
        }
        if (tryToDropCatalogs || tryToDropSchemas) {
            HashSet<Identifier> exportedCatalogs = new HashSet<Identifier>();
            for (Namespace namespace : database.getNamespaces()) {
                if (tryToDropSchemas && namespace.getPhysicalName().getSchema() != null) {
                    SchemaDropperImpl.applySqlStrings(targets, dialect.getDropSchemaCommand(namespace.getPhysicalName().getSchema().render(dialect)));
                }
                if (!tryToDropCatalogs) continue;
                Identifier identifier = namespace.getName().getCatalog();
                Identifier catalogPhysicalName = namespace.getPhysicalName().getCatalog();
                if (catalogPhysicalName == null || exportedCatalogs.contains(identifier)) continue;
                SchemaDropperImpl.applySqlStrings(targets, dialect.getDropCatalogCommand(catalogPhysicalName.render(dialect)));
                exportedCatalogs.add(identifier);
            }
        }
        Iterator<Object> iterator = targets;
        int n = ((Iterator<Object>)iterator).length;
        boolean bl = false;
        while (var12_24 < n) {
            Iterator<Object> iterator2 = iterator[var12_24];
            iterator2.release();
            ++var12_24;
        }
    }

    private void applyConstraintDropping(Target[] targets, Namespace namespace, Metadata metadata) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        if (!dialect.dropConstraints()) {
            return;
        }
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable()) continue;
            Iterator fks = table.getForeignKeyIterator();
            while (fks.hasNext()) {
                ForeignKey foreignKey = (ForeignKey)fks.next();
                SchemaDropperImpl.applySqlStrings(targets, dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata));
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    private static void applySqlStrings(Target[] targets, String ... sqlStrings) {
        if (sqlStrings == null) {
            return;
        }
        for (Target target : targets) {
            for (String sqlString : sqlStrings) {
                target.accept(sqlString);
            }
        }
    }
}

