/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import java.util.Collection;
import java.util.Locale;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.internal.util.compare.EqualsHelper;

public abstract class AttributeTypeDescriptor {
    public abstract String buildReadInterceptionBodyFragment(String var1);

    public abstract String buildWriteInterceptionBodyFragment(String var1);

    public String buildInLineDirtyCheckingBodyFragment(EnhancementContext context, CtField currentValue) {
        StringBuilder builder = new StringBuilder();
        try {
            if (PersistentAttributesHelper.hasAnnotation(currentValue, Id.class) || PersistentAttributesHelper.hasAnnotation(currentValue, EmbeddedId.class)) {
                return "";
            }
            if (currentValue.getType().isPrimitive() || currentValue.getType().isEnum()) {
                builder.append(String.format("  if (%s != $1)", currentValue.getName()));
            } else {
                for (CtClass ctClass : currentValue.getType().getInterfaces()) {
                    if (!ctClass.getName().equals(Collection.class.getName()) || !context.isMappedCollection(currentValue)) continue;
                    return "";
                }
                builder.append(String.format("  if ( !%s.areEqual( %s, $1 ) )", EqualsHelper.class.getName(), currentValue.getName()));
            }
            builder.append(String.format("  {  %s(\"%s\");  }", "$$_hibernate_trackChange", currentValue.getName()));
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static AttributeTypeDescriptor resolve(CtField persistentField) throws NotFoundException {
        if (persistentField.getType() == CtClass.booleanType) {
            return new PrimitiveAttributeTypeDescriptor(Boolean.TYPE);
        }
        if (persistentField.getType() == CtClass.byteType) {
            return new PrimitiveAttributeTypeDescriptor(Byte.TYPE);
        }
        if (persistentField.getType() == CtClass.charType) {
            return new PrimitiveAttributeTypeDescriptor(Character.TYPE);
        }
        if (persistentField.getType() == CtClass.shortType) {
            return new PrimitiveAttributeTypeDescriptor(Short.TYPE);
        }
        if (persistentField.getType() == CtClass.intType) {
            return new PrimitiveAttributeTypeDescriptor(Integer.TYPE);
        }
        if (persistentField.getType() == CtClass.longType) {
            return new PrimitiveAttributeTypeDescriptor(Long.TYPE);
        }
        if (persistentField.getType() == CtClass.doubleType) {
            return new PrimitiveAttributeTypeDescriptor(Double.TYPE);
        }
        if (persistentField.getType() == CtClass.floatType) {
            return new PrimitiveAttributeTypeDescriptor(Float.TYPE);
        }
        return new ObjectAttributeTypeDescriptor(persistentField.getType());
    }

    private static class PrimitiveAttributeTypeDescriptor
    extends AttributeTypeDescriptor {
        private final String type;

        private PrimitiveAttributeTypeDescriptor(Class<?> primitiveType) {
            if (!primitiveType.isPrimitive()) {
                throw new IllegalArgumentException("Primitive attribute type descriptor can only be used on primitive types");
            }
            this.type = primitiveType.getSimpleName().substring(0, 1).toUpperCase(Locale.ROOT) + primitiveType.getSimpleName().substring(1);
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("  if (%3$s() != null ) { this.%1$s = %3$s().read%2$s(this, \"%1$s\", this.%1$s); }", fieldName, this.type, "$$_hibernate_getInterceptor");
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("  %2$s localVar = $1;%n  if ( %4$s() != null ) { localVar = %4$s().write%3$s(this, \"%1$s\", this.%1$s, $1); }%n  this.%1$s = localVar;", fieldName, this.type.toLowerCase(Locale.ROOT), this.type, "$$_hibernate_getInterceptor");
        }
    }

    private static class ObjectAttributeTypeDescriptor
    extends AttributeTypeDescriptor {
        private final String type;

        private ObjectAttributeTypeDescriptor(CtClass concreteType) {
            this.type = concreteType.getName();
        }

        @Override
        public String buildReadInterceptionBodyFragment(String fieldName) {
            return String.format("  if ( %3$s() != null ) { this.%1$s = (%2$s) %3$s().readObject(this, \"%1$s\", this.%1$s); }%n", fieldName, this.type, "$$_hibernate_getInterceptor");
        }

        @Override
        public String buildWriteInterceptionBodyFragment(String fieldName) {
            return String.format("  %2$s localVar = $1;%n  if ( %3$s() != null ) { localVar = (%2$s) %3$s().writeObject(this, \"%1$s\", this.%1$s, $1); }%n  this.%1$s = localVar;", fieldName, this.type, "$$_hibernate_getInterceptor");
        }
    }
}

