/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.hdiv.validator.IValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validation
implements IValidation {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Validation.class);
    protected String name;
    protected Pattern acceptedPattern;
    protected Pattern rejectedPattern;
    protected String componentType;
    protected boolean defaultValidation = false;

    protected boolean existComponentType() {
        return this.componentType != null;
    }

    protected boolean isTheSameComponentType(String parameterType) {
        if ("password".equals(parameterType)) {
            return "text".equals(this.componentType);
        }
        return this.componentType.equalsIgnoreCase(parameterType);
    }

    public boolean validate(String parameter, String[] values, String dataType) {
        if (dataType != null && this.existComponentType() && !this.isTheSameComponentType(dataType)) {
            return true;
        }
        for (String value : values) {
            Matcher m;
            if (value == null) continue;
            if (this.acceptedPattern != null) {
                try {
                    m = this.acceptedPattern.matcher(value);
                    if (!m.matches()) {
                        return false;
                    }
                }
                catch (Throwable e) {
                    log.error("Error matching pattern " + this.acceptedPattern.toString() + " with value " + value, e);
                }
            }
            if (this.rejectedPattern == null) continue;
            try {
                m = this.rejectedPattern.matcher(value);
                if (!m.matches()) continue;
                return false;
            }
            catch (Throwable e) {
                log.error("Error matching pattern " + this.rejectedPattern.toString() + " with value " + value, e);
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void setComponentType(String componentType) {
        this.componentType = componentType;
    }

    public void setAcceptedPattern(String acceptedPattern) {
        try {
            this.acceptedPattern = Pattern.compile(acceptedPattern);
        }
        catch (PatternSyntaxException ex) {
            log.error("Error compiling pattern:" + acceptedPattern + ". It will be ignored.");
            System.err.println("Error compiling pattern:" + acceptedPattern + ". It will be ignored.");
        }
    }

    public String getAcceptedPattern() {
        return this.acceptedPattern == null ? null : this.acceptedPattern.pattern();
    }

    public void setRejectedPattern(String rejectedPattern) {
        try {
            this.rejectedPattern = Pattern.compile(rejectedPattern);
        }
        catch (PatternSyntaxException ex) {
            log.error("Error compiling pattern:" + rejectedPattern + ". It will be ignored.");
            System.err.println("Error compiling pattern:" + rejectedPattern + ". It will be ignored.");
        }
    }

    public String getRejectedPattern() {
        return this.rejectedPattern == null ? null : this.rejectedPattern.pattern();
    }

    public boolean isDefaultValidation() {
        return this.defaultValidation;
    }

    public void setDefaultValidation(boolean defaultValidation) {
        this.defaultValidation = defaultValidation;
    }

    public String toString() {
        StringBuilder result = new StringBuilder().append("");
        result = result.append(" name=").append(this.getName());
        result = result.append(" componentType=").append(this.getComponentType());
        result = result.append(" acceptedPattern=").append(this.acceptedPattern == null ? "" : this.acceptedPattern.toString());
        result = result.append(" rejectedPattern=").append(this.rejectedPattern == null ? "" : this.rejectedPattern.toString());
        result = result.append(" defaultValidation=").append(this.defaultValidation);
        return result.toString();
    }
}

