/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.validator;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.ValidationRepository;
import org.hdiv.validator.ValidationTarget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidationRepository
implements ValidationRepository {
    private static final long serialVersionUID = 467553775965908017L;
    protected Map<ValidationTarget, List<IValidation>> validations;
    protected List<IValidation> defaultValidations;

    @Override
    public List<IValidation> findValidations(String url, String parameter) {
        for (Map.Entry<ValidationTarget, List<IValidation>> entry : this.validations.entrySet()) {
            ValidationTarget target = entry.getKey();
            PatternMatcher urlMatcher = target.getUrl();
            if (urlMatcher != null && !urlMatcher.matches(url)) continue;
            List<PatternMatcher> paramMatchers = target.getParams();
            boolean paramMatch = false;
            if (paramMatchers != null && !paramMatchers.isEmpty()) {
                for (PatternMatcher paramMatcher : paramMatchers) {
                    if (!paramMatcher.matches(parameter)) continue;
                    paramMatch = true;
                    break;
                }
            } else {
                paramMatch = true;
            }
            if (!paramMatch) continue;
            return entry.getValue();
        }
        return Collections.emptyList();
    }

    @Override
    public List<IValidation> findDefaultValidations() {
        return this.defaultValidations;
    }

    public void setValidations(Map<ValidationTarget, List<IValidation>> validations) {
        this.validations = validations;
    }

    public Map<ValidationTarget, List<IValidation>> getValidations() {
        return this.validations;
    }

    public List<IValidation> getDefaultValidations() {
        return this.defaultValidations;
    }

    public void setDefaultValidations(List<IValidation> defaultValidations) {
        this.defaultValidations = defaultValidations;
    }
}

