/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.validator;

import java.util.List;
import org.hdiv.validator.EditableDataValidationProvider;
import org.hdiv.validator.EditableDataValidationResult;
import org.hdiv.validator.IValidation;
import org.hdiv.validator.ValidationRepository;

public class DefaultEditableDataValidationProvider
implements EditableDataValidationProvider {
    private static final long serialVersionUID = 2276666823731793620L;
    protected ValidationRepository validationRepository;

    public EditableDataValidationResult validate(String url, String parameter, String[] values, String dataType) {
        if (this.validationRepository == null) {
            return EditableDataValidationResult.VALIDATION_NOT_REQUIRED;
        }
        List<IValidation> validations = this.validationRepository.findValidations(url, parameter);
        if (validations.isEmpty()) {
            return EditableDataValidationResult.VALIDATION_NOT_REQUIRED;
        }
        for (IValidation currentValidation : validations) {
            if (currentValidation.validate(parameter, values, dataType)) continue;
            return new EditableDataValidationResult(false, currentValidation.getName());
        }
        return EditableDataValidationResult.VALID;
    }

    public void setValidationRepository(ValidationRepository validationRepository) {
        this.validationRepository = validationRepository;
    }

    public ValidationRepository getValidationRepository() {
        return this.validationRepository;
    }
}

