/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.util;

import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.application.IApplication;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContext;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.urlProcessor.UrlDataImpl;
import org.hdiv.util.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.util.StringUtils;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.util.HtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HDIVUtil {
    private static final Logger log = LoggerFactory.getLogger(HDIVUtil.class);
    private static final String APPLICATION_SERVLETCONTEXT_KEY = "APPLICATION_SERVLETCONTEXT_KEY";
    private static final String HDIV_SERVLETCONTEXT_KEY = "HDIV_SERVLETCONTEXT_KEY";
    private static final String MESSAGESOURCE_SERVLETCONTEXT_KEY = "MESSAGESOURCE_SERVLETCONTEXT_KEY";
    private static final String HDIVCONFIG_SERVLETCONTEXT_KEY = "HDIVCONFIG_SERVLETCONTEXT_KEY";
    private static final String LINKURLPROCESSOR_SERVLETCONTEXT_KEY = "LINKURLPROCESSOR_SERVLETCONTEXT_KEY";
    private static final String FORMURLPROCESSOR_SERVLETCONTEXT_KEY = "FORMURLPROCESSOR_SERVLETCONTEXT_KEY";
    public static final Pattern intPattern = Pattern.compile("[0-9]+");
    private static final char[] jsessionLower = ";jsessionid=".toCharArray();
    private static final char[] jsessionUpper = ";JSESSIONID=".toCharArray();
    private static final char[] SEMICOLON = ";".toCharArray();
    private static final char[] QUESTION = "?".toCharArray();
    private static Random r = new Random();
    private static final String MULTIPART = "multipart/";
    private static boolean SERVLET3 = false;

    private HDIVUtil() {
    }

    public static boolean isServlet3() {
        return SERVLET3;
    }

    public static IApplication getApplication(ServletContext servletContext) {
        IApplication app = (IApplication)servletContext.getAttribute(APPLICATION_SERVLETCONTEXT_KEY);
        if (app == null) {
            throw new HDIVException("IApplication has not been initialized in servlet context");
        }
        return app;
    }

    public static void setApplication(IApplication newApplication, ServletContext servletContext) {
        servletContext.setAttribute(APPLICATION_SERVLETCONTEXT_KEY, (Object)newApplication);
    }

    public static HDIVConfig getHDIVConfig(ServletContext servletContext) {
        HDIVConfig hdivConfig = (HDIVConfig)servletContext.getAttribute(HDIVCONFIG_SERVLETCONTEXT_KEY);
        if (hdivConfig == null) {
            throw new HDIVException("HDIVConfig has not been initialized in servlet context");
        }
        return hdivConfig;
    }

    public static void setHDIVConfig(HDIVConfig hdivConfig, ServletContext servletContext) {
        servletContext.setAttribute(HDIVCONFIG_SERVLETCONTEXT_KEY, (Object)hdivConfig);
    }

    public static LinkUrlProcessor getLinkUrlProcessor(ServletContext servletContext) {
        LinkUrlProcessor urlProcessor = (LinkUrlProcessor)servletContext.getAttribute(LINKURLPROCESSOR_SERVLETCONTEXT_KEY);
        if (urlProcessor == null) {
            throw new HDIVException("LinkUrlProcessor has not been initialized in servlet context");
        }
        return urlProcessor;
    }

    public static void setLinkUrlProcessor(LinkUrlProcessor urlProcessor, ServletContext servletContext) {
        servletContext.setAttribute(LINKURLPROCESSOR_SERVLETCONTEXT_KEY, (Object)urlProcessor);
    }

    public static FormUrlProcessor getFormUrlProcessor(ServletContext servletContext) {
        FormUrlProcessor urlProcessor = (FormUrlProcessor)servletContext.getAttribute(FORMURLPROCESSOR_SERVLETCONTEXT_KEY);
        if (urlProcessor == null) {
            throw new HDIVException("FormUrlProcessor has not been initialized in servlet context");
        }
        return urlProcessor;
    }

    public static void setFormUrlProcessor(FormUrlProcessor urlProcessor, ServletContext servletContext) {
        servletContext.setAttribute(FORMURLPROCESSOR_SERVLETCONTEXT_KEY, (Object)urlProcessor);
    }

    public static MessageSource getMessageSource(HttpServletRequest request) {
        return HDIVUtil.getMessageSource(request.getSession().getServletContext());
    }

    public static MessageSource getMessageSource(ServletContext servletContext) {
        MessageSource msgSource = (MessageSource)servletContext.getAttribute(MESSAGESOURCE_SERVLETCONTEXT_KEY);
        if (msgSource == null) {
            throw new HDIVException("MessageSource has not been initialized in servlet context");
        }
        return msgSource;
    }

    public static void setMessageSource(MessageSource msgSource, ServletContext servletContext) {
        servletContext.setAttribute(MESSAGESOURCE_SERVLETCONTEXT_KEY, (Object)msgSource);
    }

    public static String getMessage(HttpServletRequest request, String key) {
        return HDIVUtil.getMessage(request, key, null);
    }

    public static String getMessage(HttpServletRequest request, String key, String o) {
        return HDIVUtil.getMessage(request, key, o, Locale.getDefault());
    }

    public static String getMessage(HttpServletRequest request, String key, String o, Locale userLocale) {
        String resolvedMessage = HDIVUtil.getMessageSource(request).getMessage(key, (Object[])new String[]{o}, userLocale);
        log.debug(resolvedMessage);
        return resolvedMessage;
    }

    public static RequestContextHolder getRequestContext(ServletRequest request) {
        return (RequestContextHolder)request.getAttribute("HdivRC");
    }

    public static HttpServletRequest getCurrentHttpRequest() {
        return ((ServletRequestAttributes)org.springframework.web.context.request.RequestContextHolder.currentRequestAttributes()).getRequest();
    }

    @Deprecated
    public static String getHdivState(HttpServletRequest request) {
        return request.getParameter(HDIVUtil.getHdivStateParameterName(request));
    }

    @Deprecated
    public static void setHdivState(HttpServletRequest request, String value) {
        ((RequestWrapper)request).addParameter(HDIVUtil.getHdivStateParameterName(request), new String[]{value});
    }

    public static boolean isObfuscatedTarget(String target) {
        return target.indexOf("/oBfT") != -1;
    }

    public static String createRandomToken(int n) {
        int i = r.nextInt(n);
        if (i == 0) {
            i = 1;
        }
        return String.valueOf(i);
    }

    public static String stripSession(String url) {
        return HDIVUtil.stripAndFillSessionData(url, null);
    }

    public static String stripAndFillSessionData(String url, UrlDataImpl urldata) {
        char[] data;
        int sessionStart;
        int pos = url.indexOf(59);
        if (pos != -1 && ((sessionStart = HDIVUtil.indexOf(data = url.toCharArray(), jsessionLower, pos)) != -1 || (sessionStart = HDIVUtil.indexOf(data, jsessionUpper, pos)) != -1)) {
            int len;
            int sessionEnd = HDIVUtil.indexOf(data, SEMICOLON, sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = HDIVUtil.indexOf(data, QUESTION, sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = data.length;
            }
            if ((len = sessionEnd - sessionStart) > 0) {
                if (urldata != null) {
                    urldata.setjSessionId(new String(data, sessionStart + 1, len - 1));
                }
                System.arraycopy(data, sessionStart + len, data, sessionStart, data.length - sessionEnd);
                return new String(data, 0, data.length - len);
            }
        }
        return url;
    }

    private static int indexOf(char[] source, char[] target, int fromIndex) {
        char first = target[0];
        int max = source.length - target.length;
        for (int i = 0 + fromIndex; i <= max; ++i) {
            if (source[i] != first) {
                while (++i <= max && source[i] != first) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + target.length - 1;
            int k = 1;
            while (j < end && source[j] == target[k]) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static <T> T getNativeRequest(ServletRequest request, Class<T> requiredType) {
        if (requiredType != null) {
            if (requiredType.isInstance(request)) {
                return (T)request;
            }
            if (request instanceof ServletRequestWrapper) {
                return HDIVUtil.getNativeRequest(((ServletRequestWrapper)request).getRequest(), requiredType);
            }
        }
        return null;
    }

    public static ApplicationContext findWebApplicationContext(ServletContext sc) {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        ApplicationContext backupCandidate = null;
        if (wac == null) {
            Enumeration attrNames = sc.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attrValue = sc.getAttribute(attrName);
                if (attrValue instanceof WebApplicationContext) {
                    if (wac != null) {
                        throw new IllegalStateException("No unique WebApplicationContext found: more than one DispatcherServlet registered with publishContext=true?");
                    }
                    wac = (WebApplicationContext)attrValue;
                    continue;
                }
                if (!(attrValue instanceof ApplicationContext) || !attrName.equals(HDIV_SERVLETCONTEXT_KEY)) continue;
                backupCandidate = (ApplicationContext)attrValue;
            }
        }
        if (wac == null) {
            if (backupCandidate != null) {
                return backupCandidate;
            }
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    public static void registerApplicationContext(ApplicationContext context, ServletContext scontext) {
        scontext.setAttribute(HDIV_SERVLETCONTEXT_KEY, (Object)context);
    }

    public static String getDecodedValue(StringBuilder sb, String value, String charEncoding) {
        if (value == null || value.length() == 0) {
            return "";
        }
        String decodedValue = null;
        try {
            decodedValue = HDIVUtil.decodeValue(sb, value, charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            decodedValue = value;
        }
        catch (IllegalArgumentException e) {
            decodedValue = value;
        }
        if (decodedValue.indexOf(38) != -1) {
            decodedValue = HtmlUtils.htmlUnescape((String)decodedValue);
        }
        return decodedValue;
    }

    public static boolean isTheSameEncodedValue(String parameterValue, String value) {
        boolean equals;
        if (parameterValue.replace(" ", "+").equalsIgnoreCase(value)) {
            return true;
        }
        String fix = HDIVUtil.reDecodeValue(value);
        boolean bl = equals = fix != null && fix.equals(parameterValue);
        if (equals) {
            return true;
        }
        fix = HDIVUtil.reDecodeValue(parameterValue);
        return fix != null && fix.equals(value);
    }

    private static String reDecodeValue(String value) {
        try {
            value = URLEncoder.encode(value, "ISO-8859-1");
            value = URLDecoder.decode(value, "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
        return value;
    }

    public static String decodeValue(StringBuilder sb, String s, String enc) throws UnsupportedEncodingException {
        sb.setLength(0);
        boolean needToChange = false;
        int numChars = s.length();
        int i = 0;
        if (enc.length() == 0) {
            throw new UnsupportedEncodingException("URLDecoder: empty string enc parameter");
        }
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    needToChange = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos, enc));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public static boolean isPathVariable(String uriTemplate, String variable) {
        return uriTemplate.indexOf('{' + variable + '}') != -1;
    }

    public static boolean isMultipartContent(HttpServletRequest request) {
        if (!Method.POST.toString().equalsIgnoreCase(request.getMethod())) {
            return false;
        }
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(MULTIPART);
    }

    @Deprecated
    public static String getRequestURI(HttpServletRequest request) {
        return HDIVUtil.getRequestContext((ServletRequest)request).getRequestURI();
    }

    @Deprecated
    public static void setRequestURI(String requestURI, HttpServletRequest request) {
        HDIVUtil.getContext((ServletRequest)request).setRequestURI(requestURI);
    }

    @Deprecated
    public static Integer getCurrentPageId(ServletRequest request) {
        return (int)HDIVUtil.getRequestContext(request).getCurrentPageId().getLeastSignificantBits();
    }

    @Deprecated
    public static void setCurrentPageId(Integer pageId, ServletRequest request) {
        HDIVUtil.getContext(request).setCurrentPageId(new UUID(0L, pageId.intValue()));
    }

    @Deprecated
    public static String getModifyHdivStateParameterName(HttpServletRequest request) {
        return HDIVUtil.getRequestContext((ServletRequest)request).getHdivModifyParameterName();
    }

    @Deprecated
    public static void setModifyHdivStateParameterName(HttpServletRequest request, String parameterName) {
        HDIVUtil.getContext((ServletRequest)request).setHdivModifyParameterName(parameterName);
    }

    @Deprecated
    private static RequestContext getContext(ServletRequest request) {
        return (RequestContext)HDIVUtil.getRequestContext(request);
    }

    @Deprecated
    public static String getHdivStateParameterName(HttpServletRequest request) {
        return HDIVUtil.getRequestContext((ServletRequest)request).getHdivParameterName();
    }

    @Deprecated
    public static void setHdivStateParameterName(HttpServletRequest request, String parameterName) {
        HDIVUtil.getContext((ServletRequest)request).setHdivParameterName(parameterName);
    }

    @Deprecated
    public static String getBaseURL(ServletRequest request) {
        return HDIVUtil.getRequestContext(request).getBaseURL();
    }

    @Deprecated
    public static void setBaseURL(String baseURL, ServletRequest request) {
        HDIVUtil.getRequestContext(request).setBaseURL(baseURL);
    }

    @Deprecated
    public static IDataComposer getDataComposer(ServletRequest request) {
        return HDIVUtil.getRequestContext(request).getDataComposer();
    }

    @Deprecated
    public static void setDataComposer(IDataComposer newDataComposer, HttpServletRequest request) {
        HDIVUtil.getRequestContext((ServletRequest)request).setDataComposer(newDataComposer);
    }

    @Deprecated
    public static void removeDataComposer(HttpServletRequest request) {
        HDIVUtil.setDataComposer(null, request);
    }

    public static String replaceOnce(String text, String searchString, String replacement) {
        return HDIVUtil.replace(text, searchString, replacement, 1, false);
    }

    public static String replace(String text, String searchString, String replacement, int max, boolean ignoreCase) {
        int start;
        int end;
        if (!StringUtils.hasLength((String)text) || !StringUtils.hasLength((String)searchString) || replacement == null || max == 0) {
            return text;
        }
        String searchText = text;
        if (ignoreCase) {
            searchText = text.toLowerCase();
            searchString = searchString.toLowerCase();
        }
        if ((end = searchText.indexOf(searchString, start = 0)) == -1) {
            return text;
        }
        int replLength = searchString.length();
        int increase = replacement.length() - replLength;
        int n = increase = increase < 0 ? 0 : increase;
        StringBuilder buf = new StringBuilder(text.length() + (increase *= max < 0 ? 16 : (max > 64 ? 64 : max)));
        while (end != -1) {
            buf.append(text.substring(start, end)).append(replacement);
            start = end + replLength;
            if (--max == 0) break;
            end = searchText.indexOf(searchString, start);
        }
        buf.append(text.substring(start));
        return buf.toString();
    }

    private static String encode(byte[] data) {
        char[] tbl = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
        StringBuilder buffer = new StringBuilder();
        int pad = 0;
        for (int i = 0; i < data.length; i += 3) {
            int b = (data[i] & 0xFF) << 16 & 0xFFFFFF;
            if (i + 1 < data.length) {
                b |= (data[i + 1] & 0xFF) << 8;
            } else {
                ++pad;
            }
            if (i + 2 < data.length) {
                b |= data[i + 2] & 0xFF;
            } else {
                ++pad;
            }
            for (int j = 0; j < 4 - pad; ++j) {
                int c = (b & 0xFC0000) >> 18;
                buffer.append(tbl[c]);
                b <<= 6;
            }
        }
        for (int j = 0; j < pad; ++j) {
            buffer.append("=");
        }
        return buffer.toString();
    }

    public static String getCustomImage(HttpServletRequest request) {
        return "http://hdiv.org/images/" + URLEncoder.encode(HDIVUtil.encode(request.getServerName().getBytes())) + "/" + URLEncoder.encode(HDIVUtil.encode(request.getContextPath().getBytes()));
    }

    public static boolean checkCustomImage(HttpServletRequest request) {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL(HDIVUtil.getCustomImage(request)).openConnection();
            return connection.getResponseCode() == HttpStatus.ACCEPTED.value();
        }
        catch (RuntimeException e) {
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    public static boolean isButtonType(String type) {
        return type != null && ("submit".equalsIgnoreCase(type) || "button".equalsIgnoreCase(type) || "image".equalsIgnoreCase(type) || "reset".equalsIgnoreCase(type));
    }

    public static boolean isNonConfidentialType(String type) {
        return type != null && (HDIVUtil.isButtonType(type) || "text".equalsIgnoreCase(type) || "textarea".equalsIgnoreCase(type));
    }

    public static <T> List<T> findBeansInWebApplicationContext(Class<T> beanType) {
        ArrayList found = new ArrayList();
        for (WebApplicationContext wac : HDIVUtil.findWebApplicationContextWithBeans(beanType)) {
            found.addAll(BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)wac, beanType, (boolean)true, (boolean)false).values());
        }
        return found;
    }

    public static List<WebApplicationContext> findWebApplicationContextWithBeans(Class<?> beanType) {
        ServletContext sc = HDIVUtil.getRequestContext((ServletRequest)HDIVUtil.getCurrentHttpRequest()).getServletContext();
        ArrayList<WebApplicationContext> found = new ArrayList<WebApplicationContext>();
        Enumeration attrNames = sc.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            Object attrValue = sc.getAttribute(attrName);
            if (!(attrValue instanceof WebApplicationContext) || BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)((WebApplicationContext)attrValue), beanType, (boolean)true, (boolean)false).isEmpty()) continue;
            found.add((WebApplicationContext)attrValue);
        }
        return found;
    }

    static {
        Cookie cookie = new Cookie("foo", "var");
        try {
            cookie.isHttpOnly();
            SERVLET3 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

