/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.util;

import java.util.UUID;
import org.hdiv.exception.HDIVException;
import org.hdiv.idGenerator.FastUUID;
import org.hdiv.util.Constants;

public final class HDIVStateUtils {
    private HDIVStateUtils() {
    }

    public static int numParts(String hdivState) {
        return hdivState.split(Constants.STATE_ID_STR_SEPARATOR).length;
    }

    public static String encode(UUID pageId, int stateId, String suffix) {
        StringBuilder sb = new StringBuilder(40);
        HDIVStateUtils.uuidToString(sb, pageId);
        return sb.append('-').append(stateId).append('-').append(suffix).toString();
    }

    public static UUID getPageId(String stateId) {
        int firstSeparator = stateId.indexOf(45);
        if (firstSeparator == -1) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        try {
            return new UUID(0L, Integer.parseInt(stateId.substring(0, firstSeparator)));
        }
        catch (NumberFormatException ex) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
    }

    public static String uuidToString(UUID id) {
        if (id.getMostSignificantBits() == 0L) {
            return Long.toString(id.getLeastSignificantBits());
        }
        return "U" + FastUUID.asHex(id.getMostSignificantBits(), id.getLeastSignificantBits());
    }

    public static void uuidToString(StringBuilder sb, UUID id) {
        if (id.getMostSignificantBits() == 0L) {
            sb.append(id.getLeastSignificantBits());
        } else {
            sb.append('U').append(FastUUID.asHexChars(id.getMostSignificantBits(), id.getLeastSignificantBits()));
        }
    }

    public static UUID parsePageId(String pageId) {
        try {
            if (pageId.startsWith("U")) {
                return new UUID(HDIVStateUtils.parseUnsignedLong(pageId.substring(1, 17), 16), HDIVStateUtils.parseUnsignedLong(pageId.substring(17, 33), 16));
            }
            return new UUID(0L, Long.parseLong(pageId));
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    private static long parseUnsignedLong(String s, int radix) throws NumberFormatException {
        if (s == null) {
            throw new NumberFormatException("null");
        }
        int len = s.length();
        if (len > 0) {
            char firstChar = s.charAt(0);
            if (firstChar == '-') {
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", s));
            }
            if (len <= 12 || radix == 10 && len <= 18) {
                return Long.parseLong(s, radix);
            }
            long first = Long.parseLong(s.substring(0, len - 1), radix);
            int second = Character.digit(s.charAt(len - 1), radix);
            if (second < 0) {
                throw new NumberFormatException("Bad digit at end of " + s);
            }
            long result = first * (long)radix + (long)second;
            if (HDIVStateUtils.compareUnsigned(result, first) < 0) {
                throw new NumberFormatException(String.format("String value %s exceeds range of unsigned long.", s));
            }
            return result;
        }
        throw new NumberFormatException(s);
    }

    private static int compareUnsigned(long x, long y) {
        return HDIVStateUtils.compare(x + Long.MIN_VALUE, y + Long.MIN_VALUE);
    }

    private static int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static int getStateId(String stateId) {
        int start = stateId.indexOf(45);
        try {
            return Integer.parseInt(stateId.substring(start + 1, stateId.indexOf(45, start + 1)));
        }
        catch (NumberFormatException ex) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
    }

    public static String getScopedState(int stateId, String token) {
        return Integer.toString(stateId) + '-' + token;
    }

    public static int getStateFromScoped(String scoped) {
        try {
            return Integer.parseInt(scoped.substring(0, scoped.indexOf(45)));
        }
        catch (NumberFormatException ex) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
    }
}

