/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hdiv.config.HDIVConfig;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlDataImpl
implements UrlData {
    private static final Pattern NAMES_PATTERN = Pattern.compile("\\{([^/]+?)\\}");
    private final String originalUrl;
    String anchor;
    String jSessionId;
    String contextPathRelativeUrl;
    private String urlWithoutContextPath;
    private String urlParams;
    private Map<String, String[]> originalUrlParams;
    private Map<String, String[]> processedUrlParams;
    private boolean internal = true;
    String server;
    private Method method;
    String uriTemplate;
    boolean templated;
    String composedParams;
    boolean urlObfuscation;

    public UrlDataImpl(String url, Method method) {
        this.originalUrl = url;
        this.method = method;
        if (url.indexOf(123) != -1) {
            this.parser(url);
        }
    }

    public boolean isGetMethod() {
        return Method.GET == this.method;
    }

    @Override
    public boolean containsParams() {
        return this.originalUrlParams != null && this.originalUrlParams.size() > 0 || this.urlParams != null && this.urlParams.length() > 0;
    }

    public String getAnchor() {
        return this.anchor;
    }

    public String findAnchor(String url) {
        int pos = url.indexOf(35);
        if (pos >= 0) {
            this.setAnchor(url.substring(pos + 1));
            return url.substring(0, pos);
        }
        return url;
    }

    private void setAnchor(String anchor) {
        this.anchor = anchor;
    }

    @Override
    public String getContextPathRelativeUrl() {
        return this.contextPathRelativeUrl;
    }

    public void setContextPathRelativeUrl(String contextPathRelativeUrl) {
        this.contextPathRelativeUrl = contextPathRelativeUrl;
    }

    @Override
    public String getUrlWithoutContextPath() {
        return this.urlWithoutContextPath;
    }

    public void setUrlWithoutContextPath(String urlWithoutContextPath) {
        this.urlWithoutContextPath = urlWithoutContextPath;
    }

    public Map<String, String[]> getOriginalUrlParams() {
        return this.originalUrlParams;
    }

    public void setOriginalUrlParams(Map<String, String[]> originalUrlParams) {
        this.originalUrlParams = originalUrlParams;
    }

    public Map<String, String[]> getProcessedUrlParams() {
        return this.processedUrlParams;
    }

    public void setProcessedUrlParams(Map<String, String[]> processedUrlParams) {
        this.processedUrlParams = processedUrlParams;
    }

    @Override
    public boolean isInternal() {
        return this.internal;
    }

    public void setInternal(boolean internal) {
        this.internal = internal;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getjSessionId() {
        return this.jSessionId;
    }

    public void setjSessionId(String jSessionId) {
        this.jSessionId = jSessionId;
    }

    @Override
    public String getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(String urlParams) {
        this.urlParams = urlParams;
    }

    @Override
    public void setComposedUrlParams(String composedParams) {
        this.composedParams = composedParams;
    }

    public boolean hasUriTemplate() {
        return this.uriTemplate != null;
    }

    public String getUrlWithOutUriTemplate() {
        if (this.hasUriTemplate()) {
            return this.originalUrl.replace(this.getUriTemplate(), "");
        }
        return this.originalUrl;
    }

    @Override
    public String getUriTemplate() {
        return this.uriTemplate != null ? this.uriTemplate : "";
    }

    void getParamProcessedUrl(StringBuilder sb) {
        sb.setLength(0);
        if (this.server != null) {
            sb.append(this.server);
        }
        if (!this.urlObfuscation || !this.internal || this.templated) {
            sb.append(this.contextPathRelativeUrl);
        } else {
            sb.append(this.contextPathRelativeUrl.substring(0, this.contextPathRelativeUrl.length() - this.urlWithoutContextPath.length())).append('/').append("oBfT");
        }
        if (this.jSessionId != null) {
            sb.append(';').append(this.jSessionId);
        }
        if (this.composedParams != null) {
            sb.append('?').append(this.composedParams);
        } else if (this.urlParams != null && this.urlParams.length() != 0) {
            sb.append('?').append(this.urlParams);
        }
    }

    @Override
    public String getProcessedUrlWithHdivState(StringBuilder sb, String hdivParameter, String stateParam) {
        if (stateParam == null || stateParam.length() <= 0) {
            this.getParamProcessedUrl(sb);
            return sb.toString();
        }
        this.getParamProcessedUrl(sb);
        char separator = this.containsParams() ? (char)'&' : '?';
        sb.append(separator).append(hdivParameter).append('=').append(stateParam);
        if (this.uriTemplate != null) {
            sb.append(this.uriTemplate.replace('?', '&'));
        }
        if (this.anchor != null) {
            sb.append('#').append(this.anchor);
        }
        return sb.toString();
    }

    @Override
    public String getProcessedUrl(StringBuilder url) {
        this.getParamProcessedUrl(url);
        if (this.anchor != null) {
            url.append('#').append(this.anchor);
        }
        return url.toString();
    }

    private void parser(String uriTemplate) {
        int startVars = uriTemplate.lastIndexOf(47);
        Matcher matcher = NAMES_PATTERN.matcher(startVars == -1 ? uriTemplate : uriTemplate.substring(startVars));
        StringBuilder sb = null;
        boolean variable = false;
        while (matcher.find()) {
            String match = matcher.group(1);
            if (match.startsWith("?") || match.startsWith("&")) {
                int colonIdx = match.indexOf(58);
                if (colonIdx == -1) {
                    variable = true;
                    if (sb == null) {
                        sb = new StringBuilder();
                        sb.append('{');
                    }
                    sb.append(match);
                    continue;
                }
                if (colonIdx + 1 == match.length()) {
                    throw new IllegalArgumentException("No custom regular expression specified after ':' in \"" + match + "\"");
                }
                if (sb == null) {
                    sb = new StringBuilder();
                    sb.append('{');
                }
                sb.append(match.substring(0, colonIdx));
                continue;
            }
            this.templated = true;
        }
        if (variable) {
            sb.append('}');
            this.uriTemplate = sb.toString();
        }
    }

    public boolean isJS() {
        return this.originalUrl.length() > 10 && this.originalUrl.charAt(10) == ':' && this.originalUrl.toLowerCase().startsWith("javascript:");
    }

    @Override
    public boolean isHdivStateNecessary(HDIVConfig config) {
        if (this.isJS() || !this.internal || config.isStartPage(this.urlWithoutContextPath, this.method) || this.hasExtensionToExclude(config)) {
            return false;
        }
        boolean validateParamLessUrls = config.isValidationInUrlsWithoutParamsActivated();
        if (this.isGetMethod() && !validateParamLessUrls && !this.containsParams()) {
            return false;
        }
        this.urlObfuscation = config.isUrlObfuscation();
        return true;
    }

    private boolean hasExtensionToExclude(HDIVConfig config) {
        if (this.contextPathRelativeUrl.charAt(this.contextPathRelativeUrl.length() - 1) == '/') {
            return false;
        }
        List<String> excludedExtensions = config.getExcludedURLExtensions();
        if (excludedExtensions != null) {
            for (int i = 0; i < excludedExtensions.size(); ++i) {
                if (!this.contextPathRelativeUrl.endsWith(excludedExtensions.get(i))) continue;
                return true;
            }
        }
        if (this.contextPathRelativeUrl.endsWith(".jsp")) {
            return false;
        }
        List<PatternMatcher> protectedExtension = config.getProtectedURLPatterns();
        for (int i = 0; protectedExtension != null && i < protectedExtension.size(); ++i) {
            PatternMatcher extensionPattern = protectedExtension.get(i);
            if (!extensionPattern.matches(this.contextPathRelativeUrl)) continue;
            return false;
        }
        return this.contextPathRelativeUrl.charAt(0) != '/' && this.contextPathRelativeUrl.indexOf(46) == -1;
    }
}

