/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.urlProcessor.AbstractUrlProcessor;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkUrlProcessor
extends AbstractUrlProcessor {
    private static final Logger log = LoggerFactory.getLogger(LinkUrlProcessor.class);

    @Deprecated
    public final String processUrl(HttpServletRequest request, String url) {
        return this.processUrl(HDIVUtil.getRequestContext((ServletRequest)request), url);
    }

    @Deprecated
    public final String processUrl(HttpServletRequest request, String url, String encoding) {
        return this.processUrl(HDIVUtil.getRequestContext((ServletRequest)request), url, encoding);
    }

    public String processUrl(RequestContextHolder request, String url) {
        return this.processUrl(request, url, "UTF-8");
    }

    public String processUrl(RequestContextHolder request, String url, String encoding) {
        if (request == null) {
            return url;
        }
        IDataComposer dataComposer = request.getDataComposer();
        if (dataComposer == null) {
            if (log.isDebugEnabled()) {
                log.debug("IDataComposer not initialized on request. Request doesn't pass through ValidatorFilter, review it's mapping");
            }
            return url;
        }
        String hdivParameter = dataComposer.getHdivParameterName();
        UrlData urlData = this.createUrlData(url, Method.GET, hdivParameter, request);
        if (urlData.isHdivStateNecessary(this.config)) {
            dataComposer.beginRequest(Method.GET, urlData.getUrlWithoutContextPath());
            urlData.setComposedUrlParams(dataComposer.composeParams(urlData.getUrlParams(), Method.GET, encoding));
            String stateParam = dataComposer.endRequest();
            url = this.getProcessedUrlWithHdivState(dataComposer.getBuilder(), hdivParameter, urlData, stateParam);
        }
        return url;
    }
}

