/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.urlProcessor.AbstractUrlProcessor;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormUrlProcessor
extends AbstractUrlProcessor {
    private static final Logger log = LoggerFactory.getLogger(FormUrlProcessor.class);

    @Deprecated
    public final String processUrl(HttpServletRequest request, String url) {
        return this.processUrl(HDIVUtil.getRequestContext((ServletRequest)request), url, Method.POST);
    }

    @Deprecated
    public final String processUrl(HttpServletRequest request, String url, Method method) {
        return this.processUrl(HDIVUtil.getRequestContext((ServletRequest)request), url, method);
    }

    public String processUrl(RequestContextHolder request, String url) {
        return this.processUrl(request, url, Method.POST);
    }

    public String processUrl(RequestContextHolder request, String url, Method method) {
        IDataComposer dataComposer;
        if (request == null) {
            return url;
        }
        if (method == null) {
            method = Method.POST;
        }
        if ((dataComposer = request.getDataComposer()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("IDataComposer not initialized on request. Request doesn't pass through ValidatorFilter, review it's mapping");
            }
            return url;
        }
        String hdivParameter = dataComposer.getHdivParameterName();
        UrlData urlData = this.createUrlData(url, method, hdivParameter, request);
        if (urlData.isHdivStateNecessary(this.config)) {
            String stateId = dataComposer.beginRequest(method, urlData.getUrlWithoutContextPath());
            request.setFormStateId(stateId);
            String processedParams = dataComposer.composeParams(urlData.getUrlParams(), method, "UTF-8");
            urlData.setComposedUrlParams(processedParams);
            url = this.getProcessedUrl(dataComposer.getBuilder(), urlData);
        } else {
            request.setFormStateId(null);
        }
        return url;
    }
}

