/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import org.hdiv.config.HDIVConfig;
import org.hdiv.urlProcessor.UrlDataImpl;
import org.hdiv.util.Method;

public class CachedUrlDataImpl
extends UrlDataImpl {
    private HDIVStatus status;
    private int cached;
    private String cacheProcessed;

    public CachedUrlDataImpl(String url, Method method) {
        super(url, method);
    }

    void getParamProcessedUrl(StringBuilder sb) {
        if (this.cacheProcessed != null) {
            sb.setLength(0);
            sb.append(this.cacheProcessed);
            return;
        }
        super.getParamProcessedUrl(sb);
        if (this.cached > 0) {
            this.cacheProcessed = sb.toString();
        }
    }

    public String getProcessedUrlWithHdivState(StringBuilder sb, String hdivParameter, String stateParam) {
        if (stateParam == null || stateParam.length() <= 0) {
            if (this.cacheProcessed != null) {
                return this.cacheProcessed;
            }
            this.getParamProcessedUrl(sb);
            return sb.toString();
        }
        this.getParamProcessedUrl(sb);
        char separator = this.containsParams() ? (char)'&' : '?';
        sb.append(separator).append(hdivParameter).append('=').append(stateParam);
        if (this.uriTemplate != null) {
            sb.append(this.uriTemplate.replace('?', '&'));
        }
        if (this.anchor != null) {
            sb.append('#').append(this.anchor);
        }
        return sb.toString();
    }

    public boolean isHdivStateNecessary(HDIVConfig config) {
        boolean needed;
        if (this.status == null) {
            boolean needed2 = super.isHdivStateNecessary(config);
            this.status = needed2 ? HDIVStatus.ACTIVE : HDIVStatus.INACTIVE;
            return needed2;
        }
        boolean bl = needed = this.status == HDIVStatus.ACTIVE;
        if (needed) {
            this.urlObfuscation = config.isUrlObfuscation();
        }
        return needed;
    }

    public void cached() {
        if (this.cached < Integer.MAX_VALUE) {
            ++this.cached;
        }
    }

    public int getCached() {
        return this.cached;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum HDIVStatus {
        ACTIVE,
        INACTIVE;

    }
}

