/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.urlProcessor.UrlDataImpl;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUrlProcessor {
    private static final String AMP = "&amp;";
    private static final int AMP_LENGTH = "&amp;".length();
    protected HDIVConfig config;

    protected static final String processAnchorAndParameters(String url, UrlDataImpl urlData, String hdivParameter) {
        int paramInit = (url = urlData.findAnchor(url)).indexOf(63);
        if (paramInit > -1) {
            urlData.setUrlParams(AbstractUrlProcessor.removeStateParameter(hdivParameter, url.substring(paramInit + 1)));
            url = url.substring(0, paramInit);
        }
        return url;
    }

    protected String removeURITemplateParams(UrlDataImpl data) {
        return data.getUrlWithOutUriTemplate();
    }

    @Deprecated
    public final UrlData createUrlData(String url, Method method, String hdivParameter, HttpServletRequest request) {
        return this.createUrlData(url, method, hdivParameter, HDIVUtil.getRequestContext((ServletRequest)request));
    }

    public UrlData createUrlData(String url, Method method, String hdivParameter, RequestContextHolder ctx) {
        String contextPath = ctx.getContextPath();
        String serverName = ctx.getServerName();
        String baseURL = AbstractUrlProcessor.getBaseURL(ctx);
        UrlDataImpl urlData = new UrlDataImpl(url, method);
        url = this.removeURITemplateParams(urlData);
        String serverUrl = AbstractUrlProcessor.getServerFromUrl(url = AbstractUrlProcessor.processAnchorAndParameters(url, urlData, hdivParameter));
        if (serverUrl != null && serverUrl.length() > 0) {
            urlData.setServer(serverUrl);
            url = url.replaceFirst(serverUrl, "");
        }
        url = AbstractUrlProcessor.stripSession(url, urlData);
        String contextPathRelativeUrl = AbstractUrlProcessor.getContextPathRelative(baseURL, url);
        urlData.setContextPathRelativeUrl(contextPathRelativeUrl);
        boolean internal = AbstractUrlProcessor.isInternalUrl(serverName, contextPath, contextPathRelativeUrl, urlData);
        urlData.setInternal(internal);
        if (internal) {
            String urlWithoutContextPath = contextPathRelativeUrl.substring(contextPath.length());
            urlData.setUrlWithoutContextPath(urlWithoutContextPath);
        } else {
            urlData.setInternal(false);
        }
        return urlData;
    }

    @Deprecated
    protected static final String getBaseURL(HttpServletRequest request) {
        return AbstractUrlProcessor.getBaseURL(HDIVUtil.getRequestContext((ServletRequest)request));
    }

    protected static final String getBaseURL(RequestContextHolder context) {
        String baseUrl = context.getBaseURL();
        if (baseUrl != null) {
            String serverUrl = AbstractUrlProcessor.getServerFromUrl(baseUrl);
            if (serverUrl != null && serverUrl.length() > 0) {
                baseUrl = baseUrl.replaceFirst(serverUrl, "");
            }
        } else {
            baseUrl = context.getRequestURI();
        }
        return baseUrl;
    }

    protected static final String removeStateParameter(String hdivParameter, String params) {
        char first;
        int amp;
        int start;
        if (params == null || (start = params.indexOf(hdivParameter)) == -1) {
            return params;
        }
        if (start > AMP_LENGTH && (amp = params.indexOf(AMP, start - AMP_LENGTH)) != -1) {
            params = params.substring(0, amp + 1) + params.substring(amp + AMP_LENGTH);
            start = params.indexOf(hdivParameter);
        }
        if (start > 0 && (first = params.charAt(start - 1)) != '?' && first != '&') {
            return params;
        }
        int end = params.indexOf(38, start);
        if (end < 0) {
            end = params.indexOf(35, start);
        }
        if (end < 0) {
            end = params.length();
        }
        String result = params.substring(0, start);
        if ((result = result + params.substring(end, params.length())).endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    @Deprecated
    public final Map<String, String[]> getUrlParamsAsMap(StringBuilder sb, HttpServletRequest request, String urlParams) {
        return this.getUrlParamsAsMap(HDIVUtil.getRequestContext((ServletRequest)request).getHdivParameterName(), sb, urlParams);
    }

    public Map<String, String[]> getUrlParamsAsMap(String hdivParameter, StringBuilder sb, String urlParams) {
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
        if (urlParams == null) {
            return params;
        }
        String value = urlParams.replaceAll(AMP, "&");
        StringTokenizer st = new StringTokenizer(value, "&");
        while (st.hasMoreTokens()) {
            String param;
            String token = st.nextToken();
            int index = token.indexOf(61);
            String val = "";
            if (index > -1) {
                param = token.substring(0, index);
                val = token.substring(index + 1);
            } else {
                param = token;
            }
            val = HDIVUtil.getDecodedValue(sb, val, "UTF-8");
            if (param.equals(hdivParameter)) continue;
            String[] values = (String[])params.get(param);
            if (values == null) {
                values = new String[]{val};
            } else {
                int l = values.length;
                values = Arrays.copyOf(values, l + 1);
                values[l] = val;
            }
            params.put(param, values);
        }
        return params;
    }

    public String getProcessedUrlWithHdivState(StringBuilder sb, String hdivParameter, UrlData urlData, String stateParam) {
        return urlData.getProcessedUrlWithHdivState(sb, hdivParameter, stateParam);
    }

    public String getProcessedUrl(StringBuilder sb, UrlData urlData) {
        return urlData.getProcessedUrl(sb);
    }

    protected static final boolean isInternalUrl(String serverName, String contextPath, String url, UrlDataImpl urlData) {
        if (urlData.getServer() != null) {
            if (!urlData.getServer().contains(serverName)) {
                return false;
            }
            return url.startsWith(contextPath) && (url.length() == contextPath.length() || url.charAt(contextPath.length()) == '/');
        }
        if (url.startsWith(contextPath) && (url.length() == contextPath.length() || url.charAt(contextPath.length()) == '/')) {
            return true;
        }
        return url.charAt(0) != '/';
    }

    protected static String getServerFromUrl(String url) {
        int pos = url.indexOf("://");
        if (pos > 0) {
            int posicion = url.indexOf(47, pos + 3);
            if (posicion > 0) {
                url = url.substring(0, posicion);
                return url;
            }
            return url;
        }
        return null;
    }

    protected static final String getContextPathRelative(String baseUrl, String url) {
        String returnValue;
        if ("".equals(url)) {
            return baseUrl;
        }
        if (url.charAt(0) == '/') {
            returnValue = url;
        } else if (url.startsWith("..")) {
            returnValue = url;
        } else {
            String uri = baseUrl;
            uri = uri.substring(uri.indexOf(47), uri.lastIndexOf(47));
            returnValue = uri + "/" + url;
        }
        return AbstractUrlProcessor.removeRelativePaths(returnValue, baseUrl);
    }

    protected static String removeRelativePaths(String url, String originalRequestUri) {
        String urlWithoutRelativePath = url;
        if (url.startsWith("..")) {
            Stack<String> stack = new Stack<String>();
            String localUri = originalRequestUri.substring(originalRequestUri.indexOf(47), originalRequestUri.lastIndexOf(47));
            StringTokenizer localUriParts = new StringTokenizer(localUri.replace('\\', '/'), "/");
            while (localUriParts.hasMoreTokens()) {
                String part = localUriParts.nextToken();
                stack.push(part);
            }
            StringTokenizer pathParts = new StringTokenizer(url.replace('\\', '/'), "/");
            while (pathParts.hasMoreTokens()) {
                String part = pathParts.nextToken();
                if (".".equals(part)) continue;
                if ("..".equals(part)) {
                    stack.pop();
                    continue;
                }
                stack.push(part);
            }
            StringBuilder flatPathBuffer = new StringBuilder();
            for (int i = 0; i < stack.size(); ++i) {
                flatPathBuffer.append('/').append((String)stack.elementAt(i));
            }
            urlWithoutRelativePath = flatPathBuffer.toString();
        }
        return urlWithoutRelativePath;
    }

    public static final String stripSession(String url, UrlDataImpl urlData) {
        return HDIVUtil.stripAndFillSessionData(url, urlData);
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }
}

