/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state.scope;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.hdiv.state.IState;
import org.hdiv.util.HDIVStateUtils;

public class ScopedStateCache
implements Serializable {
    private static final long serialVersionUID = 5141785794691242839L;
    private final Map<Integer, StateAndToken> states = new HashMap<Integer, StateAndToken>();
    private final AtomicInteger index = new AtomicInteger();

    public String addState(IState state, String token) {
        Integer previousStateId = this.existEqualState(state);
        if (previousStateId != null) {
            StateAndToken previousState = this.states.get(previousStateId);
            return HDIVStateUtils.getScopedState(previousStateId, previousState.getToken());
        }
        int id = this.index.getAndIncrement();
        this.states.put(id, new StateAndToken(state, token));
        return HDIVStateUtils.getScopedState(id, token);
    }

    public IState getState(int stateId) {
        StateAndToken st = this.states.get(stateId);
        return st == null ? null : st.getState();
    }

    public String getStateToken(int stateId) {
        StateAndToken st = this.states.get(stateId);
        return st == null ? null : st.getToken();
    }

    protected Integer existEqualState(IState state) {
        for (Map.Entry<Integer, StateAndToken> entry : this.states.entrySet()) {
            IState cacheState = entry.getValue().getState();
            if (!this.areEqualStates(cacheState, state)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean areEqualStates(IState state1, IState state2) {
        return state1.isEquivalent(state2);
    }

    class StateAndToken
    implements Serializable {
        private static final long serialVersionUID = -7927456168851506372L;
        private final IState state;
        private final String token;

        public StateAndToken(IState state, String token) {
            this.state = state;
            this.token = token;
        }

        public IState getState() {
            return this.state;
        }

        public String getToken() {
            return this.token;
        }
    }
}

