/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state.scope;

import org.hdiv.context.RequestContextHolder;
import org.hdiv.state.IState;
import org.hdiv.state.scope.ScopedStateCache;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeType;

public abstract class AbstractStateScope
implements StateScope {
    private final String preffix;
    private final StateScopeType type;

    protected AbstractStateScope(StateScopeType type) {
        this.preffix = type.getPrefix();
        this.type = type;
    }

    public String addState(RequestContextHolder context, IState state, String token) {
        ScopedStateCache cache = this.getStateCache(context);
        if (cache == null) {
            cache = new ScopedStateCache();
        }
        String stateId = cache.addState(state, token);
        this.setStateCache(context, cache);
        return this.preffix + '-' + stateId;
    }

    public IState restoreState(RequestContextHolder context, int stateId) {
        ScopedStateCache cache = this.getStateCache(context);
        return cache == null ? null : cache.getState(stateId);
    }

    public String getStateToken(RequestContextHolder context, int stateId) {
        ScopedStateCache cache = this.getStateCache(context);
        return cache == null ? null : cache.getStateToken(stateId);
    }

    public boolean isScopeState(String stateId) {
        return stateId.length() > this.preffix.length() && stateId.charAt(this.preffix.length()) == '-' && stateId.startsWith(this.preffix);
    }

    public final String getScopePrefix() {
        return this.preffix;
    }

    public StateScopeType getScopeType() {
        return this.type;
    }

    protected abstract ScopedStateCache getStateCache(RequestContextHolder var1);

    protected abstract void setStateCache(RequestContextHolder var1, ScopedStateCache var2);
}

