/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.util.UUID;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContext;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.exception.HDIVException;
import org.hdiv.session.ISession;
import org.hdiv.state.IState;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.util.HDIVStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateUtil {
    private static final Logger log = LoggerFactory.getLogger(StateUtil.class);
    protected HDIVConfig config;
    protected ISession session;
    protected StateScopeManager stateScopeManager;

    public void init() {
        log.debug("StateUtil instance created.");
    }

    public UUID getPageId(String requestState) {
        StateScope stateScope = this.stateScopeManager.getStateScope(requestState);
        if (stateScope != null) {
            return null;
        }
        return HDIVStateUtils.getPageId(requestState);
    }

    @Deprecated
    public final IState restoreState(RequestContext context, String requestState) {
        return this.restoreState((RequestContextHolder)context, requestState);
    }

    public IState restoreState(RequestContextHolder context, String requestState) {
        IState restoredState = this.restoreMemoryState(context, requestState);
        if (restoredState == null) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        return restoredState;
    }

    @Deprecated
    public boolean isMemoryStrategy(String value) {
        return true;
    }

    @Deprecated
    protected final IState restoreMemoryState(RequestContext context, String requestState) {
        return this.restoreMemoryState((RequestContextHolder)context, requestState);
    }

    protected IState restoreMemoryState(RequestContextHolder context, String requestState) {
        int stateId;
        String sId;
        String pId;
        int firstSeparator = requestState.indexOf(45);
        int lastSeparator = requestState.lastIndexOf(45);
        if (firstSeparator == -1 || lastSeparator == -1) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        try {
            pId = requestState.substring(0, firstSeparator);
            sId = requestState.substring(firstSeparator + 1, lastSeparator);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE", e);
        }
        try {
            stateId = Integer.parseInt(sId);
        }
        catch (NumberFormatException e) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE", e);
        }
        StateScope stateScope = this.stateScopeManager.getStateScope(requestState);
        if (stateScope != null) {
            IState restoredState = stateScope.restoreState(context, stateId);
            if (restoredState == null) {
                throw new HDIVException("INVALID_PAGE_ID");
            }
            return restoredState;
        }
        IState restoredState = this.getStateFromSession(context, HDIVStateUtils.parsePageId(pId), stateId);
        return restoredState;
    }

    @Deprecated
    protected IState getStateFromSession(RequestContext context, UUID pageId, int stateId) {
        return this.getStateFromSession((RequestContextHolder)context, pageId, stateId);
    }

    protected IState getStateFromSession(RequestContextHolder context, UUID pageId, int stateId) {
        IState sessionState = this.session.getState(context, pageId, stateId);
        if (sessionState == null) {
            throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
        }
        return sessionState;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

