/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hdiv.exception.HDIVException;
import org.hdiv.state.IPage;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;
import org.hdiv.state.RandomTokenType;
import org.hdiv.util.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements IState {
    private static final long serialVersionUID = -5179573248448214135L;
    private static final int PARAMETERS_LIST_SIZE = 3;
    private String action;
    private byte[] params;
    private List<IParameter> parameters;
    private int id;
    private Method method;
    private RandomTokenType tokenType = RandomTokenType.LINK;
    private transient IPage page;

    public State() {
    }

    public State(int id) {
        this.id = id;
    }

    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParameter(IParameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<IParameter>(3);
        }
        this.parameters.add(parameter);
    }

    @Override
    public IParameter getParameter(String key) {
        if (this.parameters != null) {
            for (int i = this.parameters.size() - 1; i >= 0; --i) {
                IParameter parameter = this.parameters.get(i);
                if (!parameter.getName().equalsIgnoreCase(key)) continue;
                return parameter;
            }
        }
        return null;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getParams() {
        if (this.params == null) {
            return null;
        }
        try {
            return new String(this.params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error converting parameters to String", e);
        }
    }

    @Override
    public void setParams(String params) {
        try {
            this.params = (byte[])(params != null ? params.getBytes("UTF-8") : null);
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error converting action to byte array", e);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<String> getRequiredParams(boolean editableFieldsRequiredByDefault) {
        if (this.parameters == null) {
            return Collections.emptyList();
        }
        ArrayList<String> requiredParams = new ArrayList<String>(this.parameters.size());
        for (IParameter parameter : this.parameters) {
            if (!parameter.isRequired(editableFieldsRequiredByDefault)) continue;
            requiredParams.add(parameter.getName());
        }
        return requiredParams;
    }

    @Override
    public boolean contains(Method method) {
        return this.getMethod().equals((Object)method);
    }

    public final Method getMethod() {
        return this.method != null ? this.method : Method.GET;
    }

    @Override
    public void setMethod(Method method) {
        this.method = method;
        this.tokenType = method.isForm ? RandomTokenType.FORM : RandomTokenType.LINK;
    }

    @Override
    public boolean existParameter(String key) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append("id: ").append(this.id);
        sb.append("action: ").append(this.action);
        sb.append("parameters: ").append(this.parameters);
        sb.append("params: ").append(this.params);
        sb.append("requiredParams: ").append(this.getRequiredParams(true));
        sb.append("method: ").append((Object)(this.method == null ? Method.GET : this.method));
        return super.toString();
    }

    @Override
    public boolean isEquivalent(IState state) {
        if (!this.getAction().equals(state.getAction())) {
            return false;
        }
        if (!this.getMethod().equals((Object)((State)state).getMethod())) {
            return false;
        }
        Collection params1 = this.getParameters();
        Collection<IParameter> params2 = state.getParameters();
        if (params1 != null && params2 == null) {
            return false;
        }
        if (params1 == null && params2 != null) {
            return false;
        }
        if (params1 != null) {
            if (params1.size() != params2.size()) {
                return false;
            }
            for (IParameter param1 : params1) {
                boolean exist = false;
                for (IParameter param2 : params2) {
                    if (!this.areEqualParameters(param1, param2)) continue;
                    exist = true;
                }
                if (exist) continue;
                return false;
            }
        }
        String parameters1 = this.getParams();
        String parameters2 = state.getParams();
        if (parameters1 != null && parameters2 == null) {
            return false;
        }
        if (parameters1 == null && parameters2 != null) {
            return false;
        }
        if (parameters1 != null && !parameters1.equals(parameters2)) {
            return false;
        }
        List<String> requiredParams1 = this.getRequiredParams(true);
        List<String> requiredParams2 = state.getRequiredParams(true);
        if (requiredParams1 != null && requiredParams2 == null) {
            return false;
        }
        if (requiredParams1 == null && requiredParams2 != null) {
            return false;
        }
        if (requiredParams1 != null) {
            if (requiredParams1.size() != requiredParams2.size()) {
                return false;
            }
            for (String requiredParam : requiredParams1) {
                if (requiredParams2.contains(requiredParam)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean areEqualParameters(IParameter param1, IParameter param2) {
        if (!param1.getName().equals(param2.getName())) {
            return false;
        }
        if (param1.isActionParam() != param2.isActionParam()) {
            return false;
        }
        if (param1.isEditable() != param2.isEditable()) {
            return false;
        }
        List<String> values = param2.getValues();
        if (values.size() != param1.getValues().size()) {
            return false;
        }
        for (String paramValue : values) {
            if (param1.existValue(paramValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public RandomTokenType getTokenType() {
        return this.tokenType;
    }

    protected void setTokenType(RandomTokenType tokenType) {
        this.tokenType = tokenType;
    }

    @Override
    public IPage getPage() {
        return this.page;
    }

    @Override
    public void setPage(IPage page) {
        this.page = page;
    }
}

