/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hdiv.state.DeprecatedSince;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.state.RandomTokenType;
import org.hdiv.state.Since;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
implements IPage,
Serializable {
    private static final long serialVersionUID = -5701140762067196143L;
    private static final String NO_TOKEN = "0";
    protected List<IState> states = new ArrayList<IState>();
    @Deprecated
    @DeprecatedSince(value=1)
    protected int id;
    @Since(value=1)
    protected UUID uuid;
    protected String flowId;
    protected String randomToken;
    protected String formRandomToken;
    protected transient int size;
    protected int stateIdCounter;
    protected boolean isReused;
    protected String parentStateId;

    @Deprecated
    public Page() {
    }

    public Page(UUID id) {
        this.uuid = id;
        if (this.uuid.getMostSignificantBits() != 0L) {
            this.randomToken = NO_TOKEN;
            this.formRandomToken = NO_TOKEN;
        }
    }

    @Override
    public void addState(IState state) {
        int stateId = state.getId();
        int statesSize = this.states.size();
        if (statesSize < stateId) {
            for (int i = statesSize; i < stateId; ++i) {
                this.states.add(i, null);
            }
            this.states.add(stateId, state);
        } else if (statesSize > stateId) {
            this.states.set(stateId, state);
        } else {
            this.states.add(stateId, state);
        }
    }

    @Override
    public boolean existState(int id) {
        return this.states.get(id) != null;
    }

    @Override
    public IState getState(int id) {
        IState state = this.states.get(id);
        if (state != null) {
            state.setPage(this);
        }
        return state;
    }

    @Override
    public UUID getId() {
        return this.uuid;
    }

    @Override
    public List<? extends IState> getStates() {
        return this.states;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextStateId() {
        if (this.isReused) {
            Page page = this;
            synchronized (page) {
                return this.stateIdCounter++;
            }
        }
        return this.stateIdCounter++;
    }

    @Override
    public void markAsReused() {
        this.isReused = true;
    }

    @Override
    public boolean isReused() {
        return this.isReused;
    }

    @Override
    public int getStatesCount() {
        return this.states.size();
    }

    @Override
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @Override
    public final String getRandomToken(RandomTokenType type) {
        if (type == RandomTokenType.FORM) {
            return this.formRandomToken;
        }
        return this.randomToken;
    }

    @Override
    public void setRandomToken(String randomToken, RandomTokenType type) {
        if (type == RandomTokenType.FORM) {
            this.formRandomToken = randomToken;
        } else {
            this.randomToken = randomToken;
        }
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    @Override
    public void setParentStateId(String parentStateId) {
        this.parentStateId = parentStateId;
    }

    @Override
    public String getParentStateId() {
        return this.parentStateId;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Page:").append(this.uuid).append(' ');
        for (IState state : this.states) {
            result.append(" ").append(String.valueOf(state));
        }
        return result.toString();
    }
}

