/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.session;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hdiv.session.IStateCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateCache
implements IStateCache {
    private static final int DEFAULT_MAX_SIZE = 5;
    private static final Logger log = LoggerFactory.getLogger(StateCache.class);
    private static final long serialVersionUID = -386843742684433849L;
    private int maxSize = 5;
    private final List<UUID> pageIds = new ArrayList<UUID>();

    @Override
    public synchronized UUID addPage(UUID pageId, UUID currentPageId, boolean isRefreshRequest, boolean isAjaxRequest) {
        if (this.pageIds.contains(pageId)) {
            return null;
        }
        UUID removedKey = this.cleanBuffer(currentPageId, isRefreshRequest, isAjaxRequest);
        this.pageIds.add(pageId);
        if (log.isDebugEnabled()) {
            log.debug("Page with [" + pageId + "] added to the cache. Cache contains [" + this.pageIds + "]");
        }
        return removedKey;
    }

    private UUID cleanBuffer(UUID currentPageId, boolean isRefreshRequest, boolean isAjaxRequest) {
        UUID removed = null;
        int totalPages = this.pageIds.size();
        if (currentPageId != null && totalPages > 1 && currentPageId.equals(this.pageIds.get(totalPages - 2)) && isRefreshRequest && !isAjaxRequest) {
            removed = this.pageIds.remove(totalPages - 1);
        }
        if (this.pageIds.size() >= this.maxSize) {
            removed = this.pageIds.remove(0);
        }
        if (log.isDebugEnabled() && removed != null) {
            log.debug("Deleted pages with id [" + removed + "].");
        }
        return removed;
    }

    @Override
    public UUID getLastPageId() {
        return !this.pageIds.isEmpty() ? this.pageIds.get(this.pageIds.size() - 1) : null;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        for (UUID pageId : this.pageIds) {
            result.append(" " + pageId.getLeastSignificantBits());
        }
        result.append("]");
        return result.toString();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public List<UUID> getPageIds() {
        return this.pageIds;
    }

    public static void main(String[] args) {
        int first = 129;
        Integer second = 129;
        System.out.println(first == second);
    }
}

