/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.session;

import java.util.UUID;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.exception.HDIVException;
import org.hdiv.idGenerator.PageIdGenerator;
import org.hdiv.session.HTTPSessionCache;
import org.hdiv.session.ISession;
import org.hdiv.session.SessionModel;
import org.hdiv.session.SimpleCacheKey;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionHDIV
implements ISession,
BeanFactoryAware {
    private BeanFactory beanFactory;
    private String pageIdGeneratorName = "org.hdiv.PageIdGenerator";
    protected final HTTPSessionCache cache = new HTTPSessionCache();

    @Override
    public final UUID getPageId(RequestContextHolder context) {
        SessionModel session = context.getSession();
        PageIdGenerator pageIdGenerator = (PageIdGenerator)session.getAttribute(this.pageIdGeneratorName);
        if (pageIdGenerator == null) {
            pageIdGenerator = (PageIdGenerator)this.beanFactory.getBean(PageIdGenerator.class);
        }
        if (pageIdGenerator == null) {
            throw new HDIVException("session.nopageidgenerator");
        }
        UUID id = pageIdGenerator.getNextPageId();
        if (id == null) {
            throw new HDIVException("Incorrect PageId generated [" + id + "].");
        }
        session.setAttribute(this.pageIdGeneratorName, pageIdGenerator);
        return id;
    }

    @Override
    public IPage getPage(RequestContextHolder context, UUID pageId) {
        try {
            return this.cache.findPage(new SimpleCacheKey(context, pageId));
        }
        catch (IllegalStateException e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    @Override
    public void addPage(RequestContextHolder context, IPage page) {
        this.addPageToSession(context, page, false);
    }

    @Override
    public void addPartialPage(RequestContextHolder context, IPage page) {
        this.addPageToSession(context, page, true);
    }

    @Override
    public IState getState(RequestContextHolder context, UUID pageId, int stateId) {
        try {
            return this.getPage(context, pageId).getState(stateId);
        }
        catch (Exception e) {
            throw new HDIVException("INVALID_PAGE_ID", e);
        }
    }

    protected void addPageToSession(RequestContextHolder context, IPage page, boolean isPartial) {
        this.cache.insertPage(new SimpleCacheKey(context, page.getId()), page);
    }

    @Override
    public boolean removePage(RequestContextHolder context, UUID pageId) {
        Assert.notNull((Object)context);
        return this.cache.removePage(new SimpleCacheKey(context, pageId));
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.cache.setBeanFactory(beanFactory);
    }

    @Override
    public String getAttribute(RequestContextHolder context, String name) {
        Assert.notNull((Object)context);
        return this.getAttribute(context.getSession(), name);
    }

    public String getAttribute(SessionModel context, String name) {
        Assert.notNull((Object)name);
        return (String)context.getAttribute(name);
    }

    @Override
    public <T> T getAttribute(RequestContextHolder context, String name, Class<T> requiredType) {
        Assert.notNull((Object)context);
        Assert.notNull((Object)name);
        Assert.notNull(requiredType);
        Object result = context.getSession().getAttribute(name);
        if (result == null) {
            return null;
        }
        if (requiredType.isInstance(result)) {
            return (T)result;
        }
        throw new IllegalArgumentException("Attibute with name '" + name + "' is not of required type " + requiredType.getCanonicalName());
    }

    @Override
    public void setAttribute(RequestContextHolder context, String name, Object value) {
        Assert.notNull((Object)context);
        Assert.notNull((Object)name);
        context.getSession().setAttribute(name, value);
    }

    @Override
    public void removeAttribute(RequestContextHolder context, String name) {
        Assert.notNull((Object)context);
        Assert.notNull((Object)name);
        context.getSession().removeAttribute(name);
    }

    public void setPageIdGeneratorName(String pageIdGeneratorName) {
        this.pageIdGeneratorName = pageIdGeneratorName;
    }

    public void removeEndedPages(RequestContextHolder context, String conversationId) {
        this.cache.removeEndedPages(context, conversationId);
    }
}

