/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.session;

import java.util.List;
import java.util.UUID;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.session.IStateCache;
import org.hdiv.session.SessionHDIV;
import org.hdiv.session.SessionModel;
import org.hdiv.session.SimpleCacheKey;
import org.hdiv.state.IPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;

public class HTTPSessionCache {
    private static final Logger log = LoggerFactory.getLogger(SessionHDIV.class);
    private BeanFactory beanFactory;
    private static final String PAGE_ID_KEY_PREFIX = "hdiv-page-";

    public void insertPage(SimpleCacheKey key, IPage newPage) {
        boolean isAjaxRequest;
        UUID lastPageId;
        IPage lastPage;
        boolean isRefreshRequest;
        UUID currentPage;
        RequestContextHolder ctx = key.getRequestContext();
        SessionModel session = ctx.getSession();
        UUID pageId = newPage.getId();
        IStateCache cache = this.getStateCache(session);
        UUID removedPageId = cache.addPage(pageId, currentPage = key.getRequestContext().getCurrentPageId(), isRefreshRequest = (lastPage = (lastPageId = cache.getLastPageId()) == null ? null : this.findPage(new SimpleCacheKey(key.getRequestContext(), lastPageId))) != null && newPage.getParentStateId() != null && lastPage.getParentStateId() != null && newPage.getParentStateId().equals(lastPage.getParentStateId()), isAjaxRequest = ctx.isAjax());
        if (removedPageId != null) {
            this.deletePage(session, removedPageId);
        }
        this.saveStateCache(session, cache);
        session.setAttribute(PAGE_ID_KEY_PREFIX + newPage.getId(), newPage);
        if (log.isDebugEnabled()) {
            log.debug("Added new page with id:" + newPage.getId());
        }
        this.logCacheContent(key.getRequestContext(), cache);
    }

    public IPage findPage(SimpleCacheKey key) {
        if (log.isDebugEnabled()) {
            log.debug("Getting page with id:" + key.getPageId());
        }
        SessionModel session = key.getRequestContext().getSession();
        return (IPage)session.getAttribute(PAGE_ID_KEY_PREFIX + key.getPageId());
    }

    public boolean removePage(SimpleCacheKey key) {
        SessionModel session = key.getRequestContext().getSession();
        Object attr = session.getAttribute(PAGE_ID_KEY_PREFIX + key.getPageId());
        if (attr == null) {
            return false;
        }
        session.removeAttribute(PAGE_ID_KEY_PREFIX + key.getPageId());
        IStateCache cache = this.getStateCache(session);
        return cache.getPageIds().remove(key.getPageId());
    }

    private void deletePage(SessionModel session, UUID pageId) {
        session.removeAttribute(PAGE_ID_KEY_PREFIX + pageId);
        if (log.isDebugEnabled()) {
            log.debug("Deleted page with id:" + pageId);
        }
    }

    void removeEndedPages(RequestContextHolder context, String conversationId) {
        SessionModel session = context.getSession();
        IStateCache cache = this.getStateCache(session);
        if (log.isDebugEnabled()) {
            log.debug("Cache pages before finished pages are deleted:" + cache.toString());
        }
        List<UUID> pageIds = cache.getPageIds();
        for (int i = 0; i < pageIds.size(); ++i) {
            UUID pageId = pageIds.get(i);
            IPage currentPage = this.findPage(new SimpleCacheKey(context, pageId));
            if (currentPage == null || !conversationId.equalsIgnoreCase(currentPage.getFlowId())) continue;
            this.deletePage(context.getSession(), pageId);
            pageIds.remove(i);
            --i;
        }
        if (log.isDebugEnabled()) {
            log.debug("Cache pages after finished pages are deleted:" + cache);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logCacheContent(RequestContextHolder context, IStateCache cache) {
        if (log.isTraceEnabled()) {
            IStateCache iStateCache = cache;
            synchronized (iStateCache) {
                List<UUID> ids = cache.getPageIds();
                StringBuilder sb = new StringBuilder();
                for (UUID id : ids) {
                    IPage page = this.findPage(new SimpleCacheKey(context, id));
                    String parentPage = null;
                    if (page != null) {
                        parentPage = page.getParentStateId();
                    }
                    if (parentPage != null) {
                        parentPage = parentPage.substring(0, parentPage.indexOf(45));
                    }
                    sb.append('[').append(id).append(" (").append(parentPage).append(")] ");
                }
                log.trace("Cache content [" + sb.toString() + "]");
            }
        }
    }

    public IStateCache getStateCache(SessionModel session) {
        IStateCache cache = (IStateCache)session.getAttribute("org.hdiv.StateCache");
        if (cache == null) {
            cache = this.createStateCacheInstance();
            session.setAttribute("org.hdiv.StateCache", cache);
        }
        return cache;
    }

    protected void saveStateCache(SessionModel session, IStateCache stateCache) {
        session.setAttribute("org.hdiv.StateCache", stateCache);
    }

    protected IStateCache createStateCacheInstance() {
        return (IStateCache)this.beanFactory.getBean(IStateCache.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }
}

