/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hdiv.regex.PatternMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPatternMatcher
implements PatternMatcher {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DefaultPatternMatcher.class);
    protected final String regex;
    protected final Pattern pattern;

    public DefaultPatternMatcher(String regex) {
        this.regex = regex;
        this.pattern = Pattern.compile(regex);
    }

    public boolean matches(String input) {
        return this.execPattern(input);
    }

    protected boolean execPattern(String input) {
        Matcher matcher = this.pattern.matcher(input);
        try {
            return matcher.matches();
        }
        catch (Throwable e) {
            log.error("Error matching pattern " + matcher.toString() + " with value " + input, e);
            return false;
        }
    }

    public String getPattern() {
        return this.regex;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.regex == null ? 0 : this.regex.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultPatternMatcher other = (DefaultPatternMatcher)obj;
        return !(this.regex == null ? other.regex != null : !this.regex.equals(other.regex));
    }

    public String toString() {
        return "DefaultPatternMatcher [regex=" + this.regex + "]";
    }
}

