/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.logs;

import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.logs.IUserData;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;

public class UserData
implements IUserData {
    private final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContextHolder", (ClassLoader)UserData.class.getClassLoader());

    public String getUsername(HttpServletRequest request) {
        Principal principal = request.getUserPrincipal();
        if (principal != null && principal.getName() != null) {
            return principal.getName();
        }
        if (this.springSecurityPresent) {
            SecurityContext securityContext = SecurityContextHolder.getContext();
            if (securityContext != null && securityContext.getAuthentication() != null) {
                return securityContext.getAuthentication().getName();
            }
            securityContext = (SecurityContext)request.getSession().getAttribute("SPRING_SECURITY_CONTEXT");
            if (securityContext != null && securityContext.getAuthentication() != null) {
                return securityContext.getAuthentication().getName();
            }
        }
        return "anonymous";
    }

    public String getLocalIp(HttpServletRequest request) {
        return this.getUserLocalIP(request);
    }

    public String getRemoteIp(HttpServletRequest request) {
        return request.getRemoteAddr();
    }

    protected String getUserLocalIP(HttpServletRequest request) {
        if (request.getHeader("X-Forwarded-For") == null) {
            return request.getRemoteAddr();
        }
        return request.getHeader("X-Forwarded-For");
    }
}

