/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.logs;

import org.hdiv.filter.ValidatorError;
import org.slf4j.LoggerFactory;

public class Logger {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Logger.class);

    public void init() {
    }

    public void log(ValidatorError error) {
        this.log(error.getType(), error.getTarget(), error.getParameterName(), error.getParameterValue(), error.getOriginalParameterValue(), error.getLocalIp(), error.getRemoteIp(), error.getUserName(), error.getValidationRuleName());
    }

    protected void log(String type, String target, String parameterName, String parameterValue, String originalParameterValue, String localIp, String remoteIp, String userName, String validationRuleName) {
        String formatedData = this.format(type, target, parameterName, parameterValue, originalParameterValue, localIp, remoteIp, userName, validationRuleName);
        log.info(formatedData);
    }

    protected String format(String type, String target, String parameterName, String parameterValue, String originalParameterValue, String localIp, String remoteIp, String userName, String validationRuleName) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(type);
        buffer.append(";");
        buffer.append(target);
        buffer.append(";");
        if (parameterName != null) {
            buffer.append(parameterName);
        }
        buffer.append(";");
        if (parameterValue != null) {
            buffer.append(parameterValue);
        }
        buffer.append(";");
        if (originalParameterValue != null) {
            buffer.append(originalParameterValue);
        }
        buffer.append(";");
        if (localIp != null) {
            buffer.append(localIp);
        }
        buffer.append(";");
        if (remoteIp != null) {
            buffer.append(remoteIp);
        }
        buffer.append(";");
        if (userName != null) {
            buffer.append(userName);
        }
        buffer.append(";");
        if (validationRuleName != null) {
            buffer.append(validationRuleName);
        }
        return buffer.toString();
    }
}

