/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.listener;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.hdiv.init.ServletContextInitializer;
import org.hdiv.init.SessionInitializer;
import org.hdiv.util.HDIVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class InitListener
implements ServletContextListener,
HttpSessionListener {
    private static final Logger log = LoggerFactory.getLogger(InitListener.class);
    protected boolean servletContextInitialized = false;
    protected ServletContextInitializer servletContextInitializer;
    protected SessionInitializer sessionInitializer;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        if (wac != null) {
            this.initServletContext(servletContext);
        } else if (log.isWarnEnabled()) {
            log.warn("Hdiv's InitListener is registered before Spring's ContextLoaderListener. It must be after ContextLoaderListener.");
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        if (this.servletContextInitializer != null) {
            this.servletContextInitializer.destroyServletContext(servletContextEvent.getServletContext());
        }
    }

    protected void initServletContext(ServletContext servletContext) {
        ApplicationContext wac = HDIVUtil.findWebApplicationContext(servletContext);
        this.servletContextInitializer = (ServletContextInitializer)wac.getBean(ServletContextInitializer.class);
        this.sessionInitializer = (SessionInitializer)wac.getBean(SessionInitializer.class);
        this.servletContextInitializer.initializeServletContext(servletContext);
        this.servletContextInitialized = true;
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        ServletContext servletContext = httpSessionEvent.getSession().getServletContext();
        if (!this.servletContextInitialized) {
            this.initServletContext(servletContext);
        }
        this.sessionInitializer.initializeSession(httpSessionEvent.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        if (this.sessionInitializer != null) {
            this.sessionInitializer.destroySession(httpSessionEvent.getSession());
        }
    }
}

