/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.init;

import javax.servlet.ServletContext;
import org.hdiv.application.IApplication;
import org.hdiv.config.HDIVConfig;
import org.hdiv.init.ServletContextInitializer;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.hdiv.util.HDIVUtil;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.util.Assert;

public class DefaultServletContextInitializer
implements ServletContextInitializer,
ApplicationContextAware {
    protected HDIVConfig config;
    protected ApplicationContext applicationContext;
    protected IApplication application;
    protected LinkUrlProcessor linkUrlProcessor;
    protected FormUrlProcessor formUrlProcessor;

    public void initializeServletContext(ServletContext servletContext) {
        Assert.notNull((Object)this.config);
        Assert.notNull((Object)this.application);
        Assert.notNull((Object)this.linkUrlProcessor);
        Assert.notNull((Object)this.formUrlProcessor);
        Assert.notNull((Object)servletContext);
        HDIVUtil.setHDIVConfig(this.config, servletContext);
        HDIVUtil.setApplication(this.application, servletContext);
        HDIVUtil.setLinkUrlProcessor(this.linkUrlProcessor, servletContext);
        HDIVUtil.setFormUrlProcessor(this.formUrlProcessor, servletContext);
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBeanClassLoader(this.applicationContext.getClassLoader());
        messageSource.setBasename("org.hdiv.msg.MessageResources");
        HDIVUtil.setMessageSource((MessageSource)messageSource, servletContext);
    }

    public void destroyServletContext(ServletContext servletContext) {
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setApplication(IApplication application) {
        this.application = application;
    }

    public void setLinkUrlProcessor(LinkUrlProcessor linkUrlProcessor) {
        this.linkUrlProcessor = linkUrlProcessor;
    }

    public void setFormUrlProcessor(FormUrlProcessor formUrlProcessor) {
        this.formUrlProcessor = formUrlProcessor;
    }
}

