/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.init;

import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContext;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.filter.AsyncRequestWrapper;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.filter.ResponseWrapper;
import org.hdiv.init.RequestInitializer;
import org.hdiv.session.ISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestInitializer
implements RequestInitializer {
    protected ISession session;
    protected HDIVConfig config;
    protected static final Logger log = LoggerFactory.getLogger(DefaultRequestInitializer.class);

    public void initRequest(RequestContextHolder context) {
        RequestContext ctx = (RequestContext)context;
        ctx.setHdivParameterName(this.config.getStateParameterName());
        ctx.setHdivModifyParameterName(this.config.getModifyStateParameterName());
    }

    public void endRequest(RequestContextHolder context) {
    }

    public RequestWrapper createRequestWrapper(RequestContextHolder context) {
        return this.initializeRequestWrapper(new AsyncRequestWrapper(context));
    }

    protected RequestWrapper initializeRequestWrapper(RequestWrapper requestWrapper) {
        requestWrapper.setConfidentiality(this.config.getConfidentiality());
        requestWrapper.setCookiesConfidentiality(this.config.isCookiesConfidentialityActivated());
        requestWrapper.setSession(this.session);
        return requestWrapper;
    }

    public ResponseWrapper createResponseWrapper(RequestContextHolder context) {
        ResponseWrapper responseWrapper = new ResponseWrapper(context);
        responseWrapper.setConfidentiality(this.config.getConfidentiality());
        responseWrapper.setAvoidCookiesConfidentiality(!this.config.isCookiesConfidentialityActivated());
        responseWrapper.setSession(this.session);
        return responseWrapper;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setSession(ISession session) {
        this.session = session;
    }
}

