/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.idGenerator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;

final class RandomGuid {
    private static final Random random;
    private static final SecureRandom secureRandom;
    private static final String id;
    private static final char[] BYTE2HEX;

    private static String getHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = (bytes[j] & 0xFF) << 1;
            hexChars[j * 2] = BYTE2HEX[v];
            hexChars[j * 2 + 1] = BYTE2HEX[v + 1];
        }
        return new String(hexChars);
    }

    private RandomGuid() {
    }

    public static String getRandomGuid(boolean secure) {
        MessageDigest md5 = null;
        StringBuilder sbValueBeforeMD5 = new StringBuilder(32);
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        long rand = secure ? secureRandom.nextLong() : random.nextLong();
        sbValueBeforeMD5.append(id).append(System.currentTimeMillis()).append(':').append(rand);
        md5.update(sbValueBeforeMD5.toString().getBytes());
        return RandomGuid.getHexString(md5.digest());
    }

    static {
        BYTE2HEX = "000102030405060708090A0B0C0D0E0F101112131415161718191A1B1C1D1E1F202122232425262728292A2B2C2D2E2F303132333435363738393A3B3C3D3E3F404142434445464748494A4B4C4D4E4F505152535455565758595A5B5C5D5E5F606162636465666768696A6B6C6D6E6F707172737475767778797A7B7C7D7E7F808182838485868788898A8B8C8D8E8F909192939495969798999A9B9C9D9E9FA0A1A2A3A4A5A6A7A8A9AAABACADAEAFB0B1B2B3B4B5B6B7B8B9BABBBCBDBEBFC0C1C2C3C4C5C6C7C8C9CACBCCCDCECFD0D1D2D3D4D5D6D7D8D9DADBDCDDDEDFE0E1E2E3E4E5E6E7E8E9EAEBECEDEEEFF0F1F2F3F4F5F6F7F8F9FAFBFCFDFEFF".toCharArray();
        secureRandom = new SecureRandom();
        long secureInitializer = secureRandom.nextLong();
        random = new Random(secureInitializer);
        try {
            id = InetAddress.getLocalHost().toString() + ":";
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

