/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.util.ArrayList;
import java.util.List;
import org.hdiv.filter.ValidatorError;
import org.hdiv.state.IState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorHelperResult {
    public static final ValidatorHelperResult VALID = new ValidatorHelperResult(true);
    public static final ValidatorHelperResult VALIDATION_NOT_REQUIRED = new ValidatorHelperResult(true);
    public static final ValidatorHelperResult PEN_TESTING = new ValidatorHelperResult(false);
    private final boolean valid;
    private IState value;
    private List<ValidatorError> errors;

    public ValidatorHelperResult(boolean valid) {
        this.valid = valid;
    }

    public ValidatorHelperResult(ValidatorError error) {
        this(false, error);
    }

    public ValidatorHelperResult(List<ValidatorError> errors) {
        this.valid = false;
        this.errors = errors;
    }

    public ValidatorHelperResult(boolean valid, IState value) {
        this.valid = valid;
        this.value = value;
    }

    public ValidatorHelperResult(boolean valid, ValidatorError error) {
        this.valid = valid;
        this.errors = new ArrayList<ValidatorError>();
        this.errors.add(error);
    }

    public boolean isValid() {
        return this.valid;
    }

    public List<ValidatorError> getErrors() {
        return this.errors;
    }

    public IState getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Valid: ").append(this.valid).append(", ");
        if (this.errors != null) {
            for (ValidatorError error : this.errors) {
                b.append(" Errorcode: ").append(error.toString());
            }
        }
        if (this.value != null) {
            b.append(" Value:").append(this.value).append(", ");
        }
        if (this.equals(VALIDATION_NOT_REQUIRED)) {
            b.append(" Type: VALIDATION_NOT_REQUIRED");
        }
        return b.toString();
    }
}

