/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.DataComposerFactory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.IValidationResult;
import org.hdiv.exception.HDIVException;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.SavedCookie;
import org.hdiv.filter.StateRestorer;
import org.hdiv.filter.ValidationContext;
import org.hdiv.filter.ValidationErrorException;
import org.hdiv.filter.ValidatorError;
import org.hdiv.filter.ValidatorHelperResult;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.urlProcessor.BasicUrlProcessor;
import org.hdiv.util.HDIVStateUtils;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;
import org.hdiv.validator.EditableDataValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.HtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorHelperRequest
implements IValidationHelper,
StateRestorer {
    private static final String VALIDATION_ERROR = "validation.error";
    private static final Logger log = LoggerFactory.getLogger(ValidatorHelperRequest.class);
    protected HDIVConfig hdivConfig;
    protected StateUtil stateUtil;
    protected ISession session;
    protected IDataValidator dataValidator;
    protected DataComposerFactory dataComposerFactory;
    protected Pattern numberPattern = Pattern.compile("[0-9]+");
    protected BasicUrlProcessor urlProcessor;
    protected StateScopeManager stateScopeManager;

    @Override
    public void init() {
    }

    private void processPenTesting(ValidationContext context) {
        ValidatorHelperResult ptresult = this.restoreState(context);
        if (ptresult.isValid()) {
            ArrayList<String> editable = new ArrayList<String>();
            context.getRequestContext().getResponse().setContentType("text/html");
            if (ptresult.getValue().getParameters() != null) {
                for (IParameter parameter : ptresult.getValue().getParameters()) {
                    if (!parameter.isEditable()) continue;
                    editable.add(parameter.getName());
                }
            }
            for (int i = 0; i < editable.size(); ++i) {
                try {
                    PrintWriter out = context.getRequestContext().getResponse().getWriter();
                    if (i != 0) {
                        out.write(44);
                    }
                    out.write((String)editable.get(i));
                    out.flush();
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            throw new ValidationErrorException(ValidatorHelperResult.PEN_TESTING);
        }
    }

    @Override
    public ValidatorHelperResult validate(ValidationContext context) {
        ValidatorHelperResult result;
        String target = context.getTarget();
        RequestContextHolder ctx = context.getRequestContext();
        if (target.endsWith("/PtRp") && this.hdivConfig.isPentestingActive()) {
            this.processPenTesting(context);
        }
        if ((result = this.preValidate(context)) != null) {
            return result;
        }
        if (this.hdivConfig.hasExtensionToExclude(target)) {
            if (log.isDebugEnabled()) {
                log.debug("The target [" + target + "] has an extension to exclude from validation");
            }
            return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
        }
        if (!this.hdivConfig.isValidationInUrlsWithoutParamsActivated()) {
            boolean requestHasParameters;
            boolean bl = requestHasParameters = ctx.getParameterNames() != null && ctx.getParameterNames().hasMoreElements();
            if (!requestHasParameters) {
                if (log.isDebugEnabled()) {
                    log.debug("The url [" + ctx.getRequestURI() + "] is not be validated because it has not got parameters");
                }
                return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
            }
        }
        if (this.isStartPage(ctx, target)) {
            result = this.validateStartPageParameters(ctx, target);
            if (result.isValid()) {
                if (log.isDebugEnabled()) {
                    log.debug("The target [" + target + "] is an start page and parameters are valid.");
                }
                return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
            }
            if (log.isDebugEnabled()) {
                log.debug("The target [" + target + "] is an start page and parameters are NOT valid.");
            }
            return result;
        }
        if (this.hdivConfig.isCookiesIntegrityActivated() && !(result = this.validateRequestCookies(context, target)).isValid()) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid cookies found.");
            }
            return result;
        }
        String hdivParameter = context.getRequestContext().getHdivParameterName();
        result = this.restoreState(context);
        if (!result.isValid()) {
            if (log.isDebugEnabled()) {
                log.debug("Error restoring the state: " + result);
            }
            return result;
        }
        IState state = result.getValue();
        if (!(result = this.isTheSameAction(ctx, target, state)).isValid()) {
            return result;
        }
        Map<String, String[]> stateParams = this.urlProcessor.getUrlParamsAsMap(hdivParameter, context.getBuffer(), state.getParams());
        result = this.allRequiredParametersReceived(ctx, state, target, stateParams);
        if (!result.isValid()) {
            return result;
        }
        ArrayList<ValidatorError> unauthorizedEditableParameters = new ArrayList<ValidatorError>();
        Enumeration<String> parameters = ctx.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = parameters.nextElement();
            result = this.validateParameter(ctx, stateParams, state.getParameter(parameter), stateParams.get(parameter), unauthorizedEditableParameters, hdivParameter, target, parameter);
            if (result.isValid()) continue;
            return result;
        }
        if (!unauthorizedEditableParameters.isEmpty()) {
            return new ValidatorHelperResult(unauthorizedEditableParameters);
        }
        return ValidatorHelperResult.VALID;
    }

    @Deprecated
    protected final boolean isStartPage(HttpServletRequest request, String target) {
        throw new UnsupportedOperationException();
    }

    protected boolean isStartPage(RequestContextHolder request, String target) {
        return this.hdivConfig.isStartPage(target, Method.secureValueOf(request.getMethod()));
    }

    @Deprecated
    protected final ValidatorHelperResult isTheSameAction(HttpServletRequest request, String target, IState state) {
        return this.isTheSameAction(request, target, state.getAction());
    }

    @Deprecated
    protected final ValidatorHelperResult isTheSameAction(HttpServletRequest request, String target, String stateAction) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult isTheSameAction(RequestContextHolder context, String target, IState state) {
        return this.isTheSameAction(context, target, state.getAction());
    }

    protected ValidatorHelperResult isTheSameAction(RequestContextHolder context, String target, String stateAction) {
        String actionSlash;
        if ((stateAction = HtmlUtils.htmlUnescape((String)stateAction)).equalsIgnoreCase(target)) {
            return ValidatorHelperResult.VALID;
        }
        if (target.endsWith("/") && (actionSlash = stateAction + "/").equalsIgnoreCase(target)) {
            return ValidatorHelperResult.VALID;
        }
        if (log.isDebugEnabled()) {
            log.debug("Validation error in the action. Action in state [" + stateAction + "], action in the request [" + target + "]");
        }
        ValidatorError error = new ValidatorError("INVALID_ACTION", target);
        return new ValidatorHelperResult(error);
    }

    @Deprecated
    protected final ValidatorHelperResult validateStartPageParameters(HttpServletRequest request, String target) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateStartPageParameters(RequestContextHolder request, String target) {
        ArrayList<ValidatorError> unauthorizedEditableParameters = new ArrayList<ValidatorError>();
        Enumeration<String> parameters = request.getParameterNames();
        while (parameters.hasMoreElements()) {
            String parameter = parameters.nextElement();
            String[] values = request.getParameterValues(parameter);
            this.validateEditableParameter(target, parameter, values, "text", unauthorizedEditableParameters);
        }
        if (!unauthorizedEditableParameters.isEmpty()) {
            return new ValidatorHelperResult(unauthorizedEditableParameters);
        }
        return ValidatorHelperResult.VALID;
    }

    protected final ValidatorHelperResult validateRequestCookies(ValidationContext context, String target) {
        Cookie[] requestCookies = context.getRequestContext().getCookies();
        if (requestCookies == null || requestCookies.length == 0) {
            return ValidatorHelperResult.VALID;
        }
        Map sessionCookies = this.session.getAttribute(context.getRequestContext(), "org.hdiv.HdivCookies", Map.class);
        if (sessionCookies == null) {
            return ValidatorHelperResult.VALID;
        }
        boolean cookiesConfidentiality = this.hdivConfig.getConfidentiality() && this.hdivConfig.isCookiesConfidentialityActivated();
        for (int i = 0; i < requestCookies.length; ++i) {
            boolean found = false;
            if (requestCookies[i].getName().equals("JSESSIONID") || requestCookies[i].getName().equals("HDIV_RANDOM_COOKIE")) continue;
            SavedCookie savedCookie = null;
            if (sessionCookies.containsKey(requestCookies[i].getName()) && (savedCookie = (SavedCookie)sessionCookies.get(requestCookies[i].getName())).isEqual(requestCookies[i], cookiesConfidentiality)) {
                found = true;
                if (cookiesConfidentiality && savedCookie.getValue() != null) {
                    requestCookies[i].setValue(savedCookie.getValue());
                }
            }
            if (found) continue;
            ValidatorError error = new ValidatorError("INVALID_COOKIE", target, requestCookies[i].getName(), requestCookies[i].getValue(), savedCookie != null ? savedCookie.getValue() : null);
            return new ValidatorHelperResult(error);
        }
        return ValidatorHelperResult.VALID;
    }

    protected void validateEditableParameter(String target, String parameter, String[] values, String dataType, List<ValidatorError> unauthorizedParameters) {
        EditableDataValidationResult result = this.hdivConfig.getEditableDataValidationProvider().validate(target, parameter, values, dataType);
        if (!result.isValid()) {
            String value;
            if ("password".equals(dataType)) {
                value = "hdiv.editable.password.error";
            } else {
                StringBuilder unauthorizedValues = new StringBuilder(values[0]);
                for (int i = 1; i < values.length; ++i) {
                    unauthorizedValues.append(',').append(values[i]);
                }
                value = unauthorizedValues.toString();
            }
            ValidatorError error = new ValidatorError("INVALID_EDITABLE_VALUE", target, parameter, value, null, result.getValidationId());
            unauthorizedParameters.add(error);
        }
    }

    @Deprecated
    protected final ValidatorHelperResult allRequiredParametersReceived(HttpServletRequest request, IState state, String target, Map<String, String[]> stateParams) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult allRequiredParametersReceived(RequestContextHolder request, IState state, String target, Map<String, String[]> stateParams) {
        List<String> requiredParameters = state.getRequiredParams(this.hdivConfig.getEditableFieldsRequiredByDefault());
        ArrayList<String> requiredParams = new ArrayList<String>(stateParams.keySet());
        Enumeration<String> requestParameters = request.getParameterNames();
        ArrayList<String> required = new ArrayList<String>();
        required.addAll(requiredParameters);
        required.addAll(requiredParams);
        while (requestParameters.hasMoreElements()) {
            String currentParameter = requestParameters.nextElement();
            required.remove(currentParameter);
            if (!required.isEmpty()) continue;
            return ValidatorHelperResult.VALID;
        }
        if (!required.isEmpty()) {
            Iterator it = required.iterator();
            while (it.hasNext()) {
                String req = (String)it.next();
                if (!this.isNoValueParameter(request, req)) continue;
                it.remove();
            }
        }
        return this.validateMissingParameters(request, state, target, stateParams, required);
    }

    @Deprecated
    protected final ValidatorHelperResult validateMissingParameters(HttpServletRequest request, IState state, String target, Map<String, String[]> stateParams, List<String> missingParameters) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateMissingParameters(RequestContextHolder request, IState state, String target, Map<String, String[]> stateParams, List<String> missingParameters) {
        if (missingParameters.isEmpty()) {
            return ValidatorHelperResult.VALID;
        }
        if (log.isDebugEnabled()) {
            log.debug("Missing some required parameters: " + missingParameters.toString());
        }
        ValidatorError error = new ValidatorError("NOT_RECEIVED_ALL_REQUIRED_PARAMETERS", target, missingParameters.toString());
        return new ValidatorHelperResult(error);
    }

    private boolean isNoValueParameter(RequestContextHolder request, String parameter) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        String[] parts = queryString.split("&");
        if (parts.length == 0) {
            return false;
        }
        List<String> partsList = Arrays.asList(parts);
        return partsList.contains(parameter);
    }

    @Deprecated
    protected final ValidatorHelperResult validateParameter(HttpServletRequest request, Map<String, String[]> stateParams, IParameter stateParameter, String[] actionParamValues, List<ValidatorError> unauthorizedEditableParameters, String hdivParameter, String target, String parameter) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateParameter(RequestContextHolder request, Map<String, String[]> stateParams, IParameter stateParameter, String[] actionParamValues, List<ValidatorError> unauthorizedEditableParameters, String hdivParameter, String target, String parameter) {
        if (this.isUserDefinedNonValidationParameter(target, parameter, hdivParameter)) {
            return ValidatorHelperResult.VALIDATION_NOT_REQUIRED;
        }
        if (stateParameter == null && actionParamValues == null) {
            return this.validateExtraParameter(request, stateParams, stateParameter, actionParamValues, unauthorizedEditableParameters, hdivParameter, target, parameter);
        }
        String[] values = request.getParameterValues(parameter);
        if (stateParameter != null && stateParameter.isEditable()) {
            request.addEditableParameter(parameter);
            if (stateParameter.getEditableDataType() != null) {
                this.validateEditableParameter(target, parameter, values, stateParameter.getEditableDataType(), unauthorizedEditableParameters);
            }
            return ValidatorHelperResult.VALID;
        }
        try {
            return this.validateParameterValues(request, target, stateParameter, actionParamValues, parameter, values);
        }
        catch (HDIVException e) {
            String errorMessage = request.getMessage(VALIDATION_ERROR, e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    @Deprecated
    protected final ValidatorHelperResult validateExtraParameter(HttpServletRequest request, Map<String, String[]> stateParams, IParameter stateParameter, String[] actionParamValues, List<ValidatorError> unauthorizedEditableParameters, String hdivParameter, String target, String parameter) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateExtraParameter(RequestContextHolder request, Map<String, String[]> stateParams, IParameter stateParameter, String[] actionParamValues, List<ValidatorError> unauthorizedEditableParameters, String hdivParameter, String target, String parameter) {
        if (log.isDebugEnabled()) {
            log.debug("Validation Error Detected: Parameter [" + parameter + "] does not exist in the state for action [" + target + "]");
        }
        ValidatorError error = new ValidatorError("INVALID_PARAMETER_NAME", target, parameter, request.getParameter(parameter));
        return new ValidatorHelperResult(error);
    }

    protected boolean isUserDefinedNonValidationParameter(String target, String parameter, String hdivParameter) {
        if (!this.hdivConfig.needValidation(parameter, hdivParameter)) {
            if (log.isDebugEnabled() && !parameter.equals(hdivParameter)) {
                log.debug("Parameter [" + parameter + "] doesn't need validation. It is configured as 'StartParameter'");
            }
            return true;
        }
        if (this.hdivConfig.isParameterWithoutValidation(target, parameter)) {
            if (log.isDebugEnabled()) {
                log.debug("Parameter [" + parameter + "] doesn't need validation. It is configured as 'ParameterWithoutValidation'.");
            }
            return true;
        }
        return false;
    }

    @Override
    public final ValidatorHelperResult restoreState(ValidationContext context) {
        return this.restoreState(context, context.getRequestContext().getHdivState());
    }

    @Deprecated
    protected final ValidatorHelperResult restoreState(String hdivParameter, ValidationContext context) {
        return this.restoreState(hdivParameter, context.getRequestContext(), context.getRequestedTarget(), context.getRequestContext().getParameter(hdivParameter));
    }

    @Deprecated
    protected final ValidatorHelperResult restoreState(String hdivParameter, String hdivState, ValidationContext context) {
        return this.restoreState(hdivParameter, context.getRequestContext(), context.getRequestedTarget(), hdivState);
    }

    @Deprecated
    protected final ValidatorHelperResult restoreState(String hdivParameter, HttpServletRequest request, String target, String requestState) {
        return this.restoreState(hdivParameter, HDIVUtil.getRequestContext((ServletRequest)request), target, requestState);
    }

    @Deprecated
    protected final ValidatorHelperResult restoreState(String hdivParameter, RequestContextHolder context, String target, String requestState) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ValidatorHelperResult restoreState(ValidationContext context, String requestState) {
        if (requestState == null) {
            ValidatorError error = new ValidatorError("HDIV_PARAMETER_DOES_NOT_EXIST", context.getRequestedTarget(), context.getRequestContext().getHdivParameterName());
            return new ValidatorHelperResult(error);
        }
        if (requestState.contains("#")) {
            requestState = requestState.split("#")[0];
        }
        try {
            RequestContextHolder ctx = context.getRequestContext();
            UUID pageId = this.stateUtil.getPageId(requestState);
            IState state = this.doRestoreState(context, requestState);
            ctx.setCurrentPageId(pageId);
            if (!this.validateHDIVSuffix(ctx, requestState, state)) {
                ValidatorError error = new ValidatorError("INVALID_HDIV_PARAMETER_VALUE", context.getRequestedTarget(), context.getRequestContext().getHdivParameterName(), requestState);
                return new ValidatorHelperResult(error);
            }
            return new ValidatorHelperResult(true, state);
        }
        catch (HDIVException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error while restoring state:" + requestState, (Throwable)e);
            }
            ValidatorError error = new ValidatorError(e.getMessage(), context.getRequestedTarget(), context.getRequestContext().getHdivParameterName(), requestState);
            return new ValidatorHelperResult(error);
        }
    }

    protected IState doRestoreState(ValidationContext ctx, String requestState) {
        return this.stateUtil.restoreState(ctx.getRequestContext(), requestState);
    }

    protected boolean validateHDIVSuffix(RequestContextHolder context, String value, IState restoredState) {
        int firstSeparator = value.indexOf(45);
        int lastSeparator = value.lastIndexOf(45);
        if (firstSeparator == -1) {
            return false;
        }
        if (firstSeparator >= lastSeparator) {
            return false;
        }
        try {
            String requestSuffix = value.substring(lastSeparator + 1);
            String pId = value.substring(0, firstSeparator);
            String sId = value.substring(firstSeparator + 1, lastSeparator);
            int stateId = 0;
            try {
                stateId = Integer.parseInt(sId);
            }
            catch (NumberFormatException e) {
                throw new HDIVException("INVALID_PAGE_ID", e);
            }
            StateScope stateScope = this.stateScopeManager.getStateScope(value);
            if (stateScope != null) {
                String token = stateScope.getStateToken(context, stateId);
                return requestSuffix.equals(token);
            }
            IPage currentPage = restoredState.getPage();
            if (currentPage == null) {
                currentPage = this.session.getPage(context, HDIVStateUtils.parsePageId(pId));
            }
            if (currentPage == null) {
                if (log.isErrorEnabled()) {
                    log.error("Page with id [" + pId + "] not found in session.");
                }
                throw new HDIVException("INVALID_PAGE_ID");
            }
            return currentPage.getRandomToken(restoredState.getTokenType()).equals(requestSuffix);
        }
        catch (IndexOutOfBoundsException e) {
            String errorMessage = context.getMessage(VALIDATION_ERROR, e.getMessage());
            if (log.isErrorEnabled()) {
                log.error(errorMessage);
            }
            throw new HDIVException(errorMessage, e);
        }
    }

    @Deprecated
    protected final ValidatorHelperResult validateParameterValues(HttpServletRequest request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateParameterValues(RequestContextHolder request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        try {
            if (actionParamValues != null && values.length != actionParamValues.length) {
                String valueMessage = "";
                if (values.length > actionParamValues.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Received more values than expected for the parameter '" + parameter + "'. Received=" + values + ", Expected=" + actionParamValues);
                        valueMessage = Arrays.toString(values);
                    } else {
                        log.debug("Received fewer values than expected for the parameter '" + parameter + "'. Received=" + values + ", Expected=" + actionParamValues);
                        valueMessage = Arrays.toString(actionParamValues);
                    }
                }
                ValidatorError error = new ValidatorError("NOT_RECEIVED_ALL_PARAMETER_VALUES", target, parameter, valueMessage);
                return new ValidatorHelperResult(error);
            }
            List<String> stateParamValues = stateParameter != null ? stateParameter.getValues() : Arrays.asList(actionParamValues);
            ValidatorHelperResult result = this.hasRepeatedOrInvalidValues(request, target, parameter, values, stateParamValues, stateParameter);
            if (!result.isValid()) {
                return result;
            }
            return this.validateReceivedValuesInState(request, target, stateParameter, actionParamValues, parameter, values);
        }
        catch (HDIVException e) {
            String errorMessage = request.getMessage(VALIDATION_ERROR, e.getMessage());
            throw new HDIVException(errorMessage, e);
        }
    }

    @Deprecated
    protected final ValidatorHelperResult hasRepeatedOrInvalidValues(HttpServletRequest request, String target, String parameter, String[] values, List<String> stateValues) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final ValidatorHelperResult hasRepeatedOrInvalidValues(RequestContextHolder request, String target, String parameter, String[] values, List<String> stateValues) {
        return this.hasRepeatedOrInvalidValues(request, target, parameter, values, stateValues, null);
    }

    protected final ValidatorHelperResult hasRepeatedOrInvalidValues(RequestContextHolder request, String target, String parameter, String[] values, List<String> stateValues, IParameter stateParameter) {
        ArrayList<String> tempStateValues = new ArrayList<String>();
        tempStateValues.addAll(stateValues);
        if (this.hdivConfig.getConfidentiality()) {
            return this.hasConfidentialIncorrectValues(request, target, parameter, values, tempStateValues, stateParameter);
        }
        return this.hasNonConfidentialIncorrectValues(target, parameter, values, tempStateValues);
    }

    @Deprecated
    protected final ValidatorHelperResult hasConfidentialIncorrectValues(HttpServletRequest request, String target, String parameter, String[] values, List<String> stateValues) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final ValidatorHelperResult hasConfidentialIncorrectValues(RequestContextHolder request, String target, String parameter, String[] values, List<String> stateValues) {
        return this.hasConfidentialIncorrectValues(request, target, parameter, values, stateValues, null);
    }

    protected final ValidatorHelperResult hasConfidentialIncorrectValues(RequestContextHolder request, String target, String parameter, String[] values, List<String> stateValues, IParameter stateParameter) {
        HashSet<String> receivedValues = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            if (this.hdivConfig.isParameterWithoutConfidentiality(request, parameter) || stateParameter != null && HDIVUtil.isNonConfidentialType(stateParameter.getEditableDataType())) {
                return ValidatorHelperResult.VALID;
            }
            ValidatorHelperResult result = this.isInRange(target, parameter, values[i], stateValues);
            if (!result.isValid()) {
                return result;
            }
            if (receivedValues.contains(values[i])) {
                String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
                ValidatorError error = new ValidatorError("REPEATED_VALUES_FOR_PARAMETER", target, parameter, values[i], originalValue);
                return new ValidatorHelperResult(error);
            }
            receivedValues.add(values[i]);
        }
        return ValidatorHelperResult.VALID;
    }

    protected ValidatorHelperResult hasNonConfidentialIncorrectValues(String target, String parameter, String[] values, List<String> tempStateValues) {
        HashSet<String> receivedValues = new HashSet<String>();
        for (int i = 0; i < values.length; ++i) {
            boolean exists = false;
            for (int j = 0; j < tempStateValues.size() && !exists; ++j) {
                String tempValue = tempStateValues.get(j);
                if (!tempValue.equalsIgnoreCase(values[i]) && !HDIVUtil.isTheSameEncodedValue(tempValue, values[i])) continue;
                tempStateValues.remove(j);
                exists = true;
            }
            if (!exists) {
                ValidatorError error;
                String originalValue = "";
                if (tempStateValues.size() == 1) {
                    originalValue = tempStateValues.get(0);
                } else if (tempStateValues.size() > 1) {
                    originalValue = tempStateValues.toString();
                }
                if (receivedValues.contains(values[i])) {
                    error = new ValidatorError("REPEATED_VALUES_FOR_PARAMETER", target, parameter, values[i], originalValue);
                    return new ValidatorHelperResult(error);
                }
                error = new ValidatorError("INVALID_PARAMETER_VALUE", target, parameter, values[i], originalValue);
                return new ValidatorHelperResult(error);
            }
            receivedValues.add(values[i]);
        }
        return ValidatorHelperResult.VALID;
    }

    protected ValidatorHelperResult isInRange(String target, String parameter, String value, List<String> stateValues) {
        Matcher m = this.numberPattern.matcher(value);
        try {
            if (!m.matches() || Integer.parseInt(value) >= stateValues.size()) {
                String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
                ValidatorError error = new ValidatorError("INVALID_CONFIDENTIAL_VALUE", target, parameter, value, originalValue);
                return new ValidatorHelperResult(error);
            }
        }
        catch (NumberFormatException e) {
            String originalValue = stateValues.size() > 1 ? stateValues.toString() : stateValues.get(0);
            ValidatorError error = new ValidatorError("INVALID_CONFIDENTIAL_VALUE", target, parameter, value, originalValue);
            return new ValidatorHelperResult(error);
        }
        return ValidatorHelperResult.VALID;
    }

    @Deprecated
    protected final ValidatorHelperResult validateReceivedValuesInState(HttpServletRequest request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult validateReceivedValuesInState(RequestContextHolder request, String target, IParameter stateParameter, String[] actionParamValues, String parameter, String[] values) {
        int size = values.length;
        String[] originalValues = new String[size];
        for (int i = 0; i < size; ++i) {
            IValidationResult result = this.dataValidator.validate(request, values[i], target, parameter, stateParameter, actionParamValues);
            if (!result.getLegal()) {
                ValidatorError error = new ValidatorError("INVALID_PARAMETER_VALUE", target, parameter, values[i]);
                return new ValidatorHelperResult(error);
            }
            originalValues[i] = (String)result.getResult();
        }
        if (this.hdivConfig.getConfidentiality()) {
            request.addParameterToRequest(parameter, originalValues);
        }
        return ValidatorHelperResult.VALID;
    }

    @Deprecated
    protected final void addParameterToRequest(HttpServletRequest request, String name, String[] value) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    protected final void addEditableParameter(HttpServletRequest request, String name) {
        throw new UnsupportedOperationException();
    }

    protected ValidatorHelperResult preValidate(ValidationContext context) {
        return null;
    }

    @Deprecated
    protected final ValidatorHelperResult preValidate(HttpServletRequest request, String target) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startPage(RequestContextHolder request) {
        boolean exclude = this.hdivConfig.hasExtensionToExclude(request.getRequestURI());
        if (!exclude) {
            request.setDataComposer(this.dataComposerFactory.newInstance(request));
        }
    }

    @Override
    public void endPage(RequestContextHolder request) {
        IDataComposer dataComposer = request.getDataComposer();
        if (dataComposer != null) {
            dataComposer.endPage();
            boolean disableClean = Boolean.getBoolean("hdiv.async.clean.disabled");
            if (!disableClean && !request.isAsync()) {
                request.setDataComposer(null);
            }
        }
    }

    public void setStateUtil(StateUtil stateUtil) {
        this.stateUtil = stateUtil;
    }

    public void setHdivConfig(HDIVConfig hdivConfig) {
        this.hdivConfig = hdivConfig;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setDataValidator(IDataValidator dataValidator) {
        this.dataValidator = dataValidator;
    }

    public void setNumberPattern(Pattern numberPattern) {
        this.numberPattern = numberPattern;
    }

    public void setDataComposerFactory(DataComposerFactory dataComposerFactory) {
        this.dataComposerFactory = dataComposerFactory;
    }

    public void setUrlProcessor(BasicUrlProcessor urlProcessor) {
        this.urlProcessor = urlProcessor;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }

    @Override
    public boolean isInternal(HttpServletRequest request, HttpServletResponse response) {
        return false;
    }

    @Override
    public List<ValidatorError> findCustomErrors(Throwable t, String target) {
        return Collections.emptyList();
    }
}

