/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.context.RequestContextFactory;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.exception.HDIVException;
import org.hdiv.exception.SharedHdivException;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.ResponseWrapper;
import org.hdiv.filter.ValidationContextFactory;
import org.hdiv.filter.ValidatorError;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.init.RequestInitializer;
import org.hdiv.logs.IUserData;
import org.hdiv.util.HDIVErrorCodes;
import org.hdiv.util.HDIVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.filter.OncePerRequestFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(ValidatorFilter.class);
    protected HDIVConfig hdivConfig;
    protected IValidationHelper validationHelper;
    protected IMultipartConfig multipartConfig;
    protected org.hdiv.logs.Logger logger;
    protected ValidatorErrorHandler errorHandler;
    protected RequestInitializer requestInitializer;
    private RequestContextFactory requestContextFactory;
    protected IUserData userData;
    protected ValidationContextFactory validationContextFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDependencies(HttpServletRequest request) {
        if (this.validationContextFactory == null) {
            ValidatorFilter validatorFilter = this;
            synchronized (validatorFilter) {
                if (this.hdivConfig == null) {
                    ServletContext servletContext = this.getServletContext();
                    ApplicationContext context = HDIVUtil.findWebApplicationContext(servletContext);
                    this.hdivConfig = (HDIVConfig)context.getBean(HDIVConfig.class);
                    this.validationHelper = (IValidationHelper)context.getBean(IValidationHelper.class);
                    String[] names = context.getBeanNamesForType(IMultipartConfig.class);
                    if (names.length > 1) {
                        throw new HDIVException("More than one bean of type 'multipartConfig' is defined.");
                    }
                    if (names.length == 1) {
                        this.multipartConfig = (IMultipartConfig)context.getBean(IMultipartConfig.class);
                    } else {
                        try {
                            List<IMultipartConfig> configs = HDIVUtil.findBeansInWebApplicationContext(IMultipartConfig.class);
                            this.multipartConfig = !configs.isEmpty() ? configs.get(0) : null;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.requestContextFactory = (RequestContextFactory)context.getBean(RequestContextFactory.class);
                    this.userData = (IUserData)context.getBean(IUserData.class);
                    this.logger = (org.hdiv.logs.Logger)context.getBean(org.hdiv.logs.Logger.class);
                    this.errorHandler = (ValidatorErrorHandler)context.getBean(ValidatorErrorHandler.class);
                    this.requestInitializer = (RequestInitializer)context.getBean(RequestInitializer.class);
                    this.validationContextFactory = (ValidationContextFactory)context.getBean(ValidationContextFactory.class);
                    HDIVUtil.checkCustomImage(request);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Callable findAttack(Throwable e) {
        if (e instanceof Callable) {
            return (Callable)((Object)e);
        }
        if (e.getCause() != null) {
            return this.findAttack(e.getCause());
        }
        return null;
    }

    private List<ValidatorError> findErrors(Throwable e, String target, boolean allowUncontrolledOrigin) {
        Throwable current = e;
        do {
            if (current instanceof SharedHdivException) continue;
            current = current.getCause();
        } while (current != null && !(current instanceof SharedHdivException));
        if (current instanceof SharedHdivException) {
            if (log.isErrorEnabled()) {
                log.error("Exception in request validation", current);
            }
            if (!allowUncontrolledOrigin) {
                Throwable invalid;
                while ((invalid = current.getCause()) != null) {
                    if (!(invalid instanceof NullPointerException) && !(invalid instanceof IndexOutOfBoundsException) && !(invalid instanceof OutOfMemoryError) && !(invalid instanceof ClassNotFoundException) && !(invalid instanceof StackOverflowError) && !(invalid instanceof ClassCastException)) continue;
                    return null;
                }
            }
            return Collections.singletonList(new ValidatorError(current, target));
        }
        return null;
    }

    protected boolean isMultipartContent(HttpServletRequest request) {
        return HDIVUtil.isMultipartContent(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void processRequest(RequestContextHolder ctx, HttpServletRequest requestWrapper, ResponseWrapper responseWrapper, FilterChain filterChain, String obfuscated) throws IOException, ServletException {
        SharedHdivException ex = null;
        try {
            this.validationHelper.startPage(ctx);
        }
        catch (SharedHdivException e) {
            if (!this.hdivConfig.isIntegrityValidation()) {
                ex = e;
            }
            throw e;
        }
        try {
            if (obfuscated != null) {
                requestWrapper.getRequestDispatcher(obfuscated).forward((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            } else {
                filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
            }
        }
        finally {
            this.validationHelper.endPage(ctx);
        }
        if (ex != null) {
            throw new HDIVException("Wrapped exception on debug", ex);
        }
    }

    protected void completeErrorData(HttpServletRequest request, List<ValidatorError> errors) {
        String localIp = this.userData.getLocalIp(request);
        String remoteIp = this.userData.getRemoteIp(request);
        String userName = this.userData.getUsername(request);
        String contextPath = request.getContextPath();
        for (ValidatorError error : errors) {
            error.setLocalIp(localIp);
            error.setRemoteIp(remoteIp);
            error.setUserName(userName);
            String target = error.getTarget();
            if (target != null && !target.startsWith(contextPath)) {
                target = request.getContextPath() + target;
            } else if (target == null) {
                target = request.getRequestURI();
            }
            error.setTarget(target);
        }
    }

    protected void logValidationErrors(List<ValidatorError> errors) {
        for (ValidatorError error : errors) {
            this.logger.log(error);
        }
    }

    protected boolean processEditableValidationErrors(RequestContextHolder request, List<ValidatorError> errors) {
        ArrayList<ValidatorError> editableErrors = new ArrayList<ValidatorError>();
        for (ValidatorError error : errors) {
            if (!HDIVErrorCodes.isEditableError(error.getType())) continue;
            editableErrors.add(error);
        }
        if (!editableErrors.isEmpty() && this.hdivConfig.isEditableValidation()) {
            request.setAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", editableErrors);
            if (this.hdivConfig.isShowErrorPageOnEditableValidation()) {
                request.getSession().setAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR", editableErrors);
            }
        }
        return !editableErrors.isEmpty();
    }
}

