/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.UnsupportedEncodingException;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.exception.HDIVException;
import org.hdiv.filter.StateRestorer;
import org.hdiv.filter.ValidationContext;
import org.hdiv.filter.ValidatorHelperResult;
import org.hdiv.state.IState;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;

public class ValidationContextImpl
implements ValidationContext {
    private final boolean obfuscation;
    private final StateRestorer restorer;
    private final StringBuilder sb = new StringBuilder(128);
    protected String target;
    protected String redirect;
    private final Method method;
    protected final RequestContextHolder context;

    public ValidationContextImpl(RequestContextHolder context, StateRestorer restorer, boolean obfuscation) {
        this.context = context;
        this.obfuscation = obfuscation;
        this.restorer = restorer;
        this.method = Method.secureValueOf(context.getMethod());
    }

    public String getTarget() {
        if (this.target == null) {
            String target = this.getRequestedTarget();
            if (this.obfuscation && HDIVUtil.isObfuscatedTarget(target)) {
                IState state = this.restoreState();
                if (state != null) {
                    this.redirect = this.target = state.getAction();
                    this.context.setRedirectAction(this.redirect);
                }
                if (this.redirect == null) {
                    throw new HDIVException("INVALID_HDIV_PARAMETER_VALUE");
                }
            }
            if (this.target == null) {
                this.target = target;
            }
        }
        return this.target;
    }

    protected IState restoreState() {
        ValidatorHelperResult result = this.restorer.restoreState(this);
        if (result.isValid()) {
            return result.getValue();
        }
        return null;
    }

    public StringBuilder getBuffer() {
        return this.sb;
    }

    public String getRedirect() {
        return this.redirect;
    }

    protected StateRestorer getRestorer() {
        return this.restorer;
    }

    private final String getDecodedTarget(StringBuilder sb, RequestContextHolder request) {
        return this.decodeUrl(sb, HDIVUtil.stripSession(request.getUrlWithoutContextPath()));
    }

    private String decodeUrl(StringBuilder sb, String url) {
        try {
            return HDIVUtil.decodeValue(sb, url, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error decoding url", e);
        }
        catch (IllegalArgumentException e) {
            throw new HDIVException("Error decoding url", e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRequestedTarget() {
        return this.getDecodedTarget(this.sb, this.context);
    }

    public RequestContextHolder getRequestContext() {
        return this.context;
    }
}

