/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.filter.SavedCookie;
import org.hdiv.session.ISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger log = LoggerFactory.getLogger(ResponseWrapper.class);
    protected static final String SET_COOKIE = "Set-Cookie";
    protected Map<String, SavedCookie> cookies = new HashMap<String, SavedCookie>();
    protected boolean confidentiality;
    protected boolean avoidCookiesConfidentiality;
    protected RequestContextHolder requestContext;
    protected ISession session;

    public ResponseWrapper(RequestContextHolder context) {
        this(context, context.getResponse());
    }

    protected ResponseWrapper(RequestContextHolder context, HttpServletResponse response) {
        super(response);
        this.requestContext = context;
        if (log.isDebugEnabled()) {
            log.debug("New ResponseWrapper instance.");
        }
    }

    public void setHeader(String name, String value) {
        String confidentialValue = value;
        if (name.equalsIgnoreCase(SET_COOKIE)) {
            this.cookies.clear();
            this.removeCookiesFromSession();
            List<String> parseValues = this.parseCookieString(value);
            if (this.confidentiality && !this.avoidCookiesConfidentiality) {
                confidentialValue = this.replaceOriginalValues(parseValues, value);
            }
        }
        super.setHeader(name, confidentialValue);
    }

    public void addHeader(String name, String value) {
        String confidentialValue = value;
        if (name.equalsIgnoreCase(SET_COOKIE)) {
            List<String> parseValues = this.parseCookieString(value);
            if (this.confidentiality && !this.avoidCookiesConfidentiality) {
                confidentialValue = this.replaceOriginalValues(parseValues, value);
            }
        }
        super.addHeader(name, confidentialValue);
    }

    protected String replaceOriginalValues(List<String> values, String value) {
        for (String currentValue : values) {
            value = value.replaceFirst("=" + currentValue, "=0");
        }
        return value;
    }

    public void reset() {
        super.reset();
        this.cookies.clear();
        this.removeCookiesFromSession();
    }

    protected List<String> parseCookieString(String cookieString) {
        ArrayList<String> values = new ArrayList<String>();
        cookieString = cookieString.trim();
        StringTokenizer tokens = new StringTokenizer(cookieString, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(tokens.nextToken(), "=");
            String name = t.nextToken().trim();
            if (!t.hasMoreTokens()) continue;
            String value = t.nextToken().trim();
            this.cookies.put(name, new SavedCookie(name, value));
            values.add(value);
        }
        this.updateSessionCookies();
        return values;
    }

    public void addCookie(Cookie cookie) {
        this.cookies.put(cookie.getName(), new SavedCookie(cookie));
        this.updateSessionCookies();
        if (this.confidentiality && !this.avoidCookiesConfidentiality) {
            cookie.setValue("0");
        }
        super.addCookie(cookie);
    }

    protected void updateSessionCookies() {
        Map sessionOriginalCookies = this.session.getAttribute(this.requestContext, "org.hdiv.HdivCookies", Map.class);
        if (sessionOriginalCookies != null && sessionOriginalCookies.size() > 0) {
            sessionOriginalCookies.putAll(this.cookies);
            this.session.setAttribute(this.requestContext, "org.hdiv.HdivCookies", sessionOriginalCookies);
        } else {
            this.session.setAttribute(this.requestContext, "org.hdiv.HdivCookies", this.cookies);
        }
    }

    protected void removeCookiesFromSession() {
        this.session.removeAttribute(this.requestContext, "org.hdiv.HdivCookies");
    }

    public Map<String, SavedCookie> getCookies() {
        return this.cookies;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }

    public void setAvoidCookiesConfidentiality(boolean avoidCookiesConfidentiality) {
        this.avoidCookiesConfidentiality = avoidCookiesConfidentiality;
    }

    public void setSession(ISession session) {
        this.session = session;
    }
}

