/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequestWrapper;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.filter.SavedCookie;
import org.hdiv.session.ISession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger(RequestWrapper.class);
    protected static final String COOKIE = "cookie";
    private static boolean rewriteURI = false;
    protected Set<String> editableParameters = new HashSet<String>();
    protected Map<String, String[]> parameters = new HashMap<String, String[]>();
    protected Map<String, Object> elementsFile = new HashMap<String, Object>();
    protected Map<String, Object> elementsText = new HashMap<String, Object>();
    protected boolean isMultipart = false;
    protected boolean confidentiality = true;
    protected boolean cookiesConfidentiality;
    protected ISession session;
    protected final RequestContextHolder requestContext;
    private String modifiedQueryString;

    public RequestWrapper(RequestContextHolder requestContext) {
        super(requestContext.getRequest());
        this.requestContext = requestContext;
    }

    public String[] getParameterValues(String parameter) {
        if (!this.parameters.containsKey(parameter)) {
            return super.getParameterValues(parameter);
        }
        String[] data = this.parameters.get(parameter);
        if (data.getClass().isArray()) {
            return data;
        }
        return this.parameters.get(parameter);
    }

    public String getParameter(String parameter) {
        if (!this.parameters.containsKey(parameter)) {
            return super.getParameter(parameter);
        }
        String[] data = this.parameters.get(parameter);
        if (data.getClass().isArray()) {
            String[] array = data;
            return array[0];
        }
        String[] values = this.parameters.get(parameter);
        return values.length > 0 ? values[0] : null;
    }

    public Enumeration<String> getParameterNames() {
        Enumeration baseParams = super.getParameterNames();
        if (!this.isMultipart) {
            return baseParams;
        }
        ArrayList list = new ArrayList(Collections.list(baseParams));
        list.addAll(this.parameters.keySet());
        return Collections.enumeration(list);
    }

    public String getHeader(String name) {
        Map sessionCookies;
        String cookieHeader = super.getHeader(name);
        if (name.equalsIgnoreCase(COOKIE) && this.confidentiality && this.cookiesConfidentiality && (sessionCookies = this.session.getAttribute(this.requestContext, "org.hdiv.HdivCookies", Map.class)) != null) {
            return this.replaceCookieString(cookieHeader, sessionCookies);
        }
        return cookieHeader;
    }

    public Enumeration<String> getHeaders(String name) {
        Enumeration headerValues = super.getHeaders(name);
        if (name.equalsIgnoreCase(COOKIE) && this.confidentiality && this.cookiesConfidentiality) {
            Map sessionCookies = this.session.getAttribute(this.requestContext, "org.hdiv.HdivCookies", Map.class);
            if (sessionCookies == null) {
                return headerValues;
            }
            ArrayList<String> values = new ArrayList<String>();
            while (headerValues.hasMoreElements()) {
                String element = (String)headerValues.nextElement();
                String replaced = this.replaceCookieString(element, sessionCookies);
                values.add(replaced);
            }
            return Collections.enumeration(values);
        }
        return headerValues;
    }

    protected String replaceCookieString(String cookieHeader, Map<String, SavedCookie> sessionCookies) {
        String header = cookieHeader.trim();
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(tokens.nextToken(), "=");
            String name = t.nextToken().trim();
            if (name.equals("JSESSIONID") || !sessionCookies.containsKey(name) || !t.hasMoreTokens()) continue;
            String value = t.nextToken().trim();
            SavedCookie savedCookie = sessionCookies.get(name);
            header = header.replaceFirst("=" + value, "=" + savedCookie.getValue());
        }
        return header;
    }

    public void addParameter(String name, String[] value) {
        this.parameters.put(name, value);
        if (rewriteURI) {
            this.modifiedQueryString = RequestWrapper.updateQueryString(this.getQueryString(), this.modifiedQueryString, name, value[0]);
        }
        if (this.isMultipart) {
            this.addTextParameter(name, value);
        }
    }

    static String updateQueryString(String queryString, String modifiedQueryString, String name, String value) {
        int start;
        if (queryString != null && (start = queryString.indexOf(name + "=")) != -1) {
            int end = queryString.indexOf(38, start += name.length() + 1);
            if (end == -1) {
                end = queryString.length();
            }
            return queryString.substring(0, start) + value + queryString.substring(end);
        }
        return modifiedQueryString;
    }

    public String getQueryString() {
        if (this.modifiedQueryString != null) {
            return this.modifiedQueryString;
        }
        return super.getQueryString();
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(super.getRequest().getParameterMap());
        map.putAll(this.parameters);
        return map;
    }

    public void setAttribute(String name, Object o) {
        if ("HdivRC".equals(name) && super.getAttribute("HdivRC") != null) {
            log.warn("The application is trying to modify an Hdiv internal attribute. The change will be avoided.");
            return;
        }
        super.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        if ("HdivRC".equals(name) && super.getAttribute("HdivRC") != null) {
            log.warn("The application is trying to remove an Hdiv internal attribute. The change will be avoided.");
            return;
        }
        super.removeAttribute(name);
    }

    public Map<String, Object> getTextElements() {
        return this.elementsText;
    }

    public Map<String, Object> getFileElements() {
        return this.elementsFile;
    }

    public void addTextParameter(String name, Object value) {
        this.elementsText.put(name, value);
    }

    public void addFileItem(String name, Object values) {
        this.elementsFile.put(name, values);
    }

    public void addEditableParameter(String parameter) {
        this.editableParameters.add(parameter);
    }

    public boolean isEditableParameter(String parameter) {
        return this.editableParameters.contains(parameter);
    }

    public void setMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
    }

    public void setCookiesConfidentiality(boolean cookiesConfidentiality) {
        this.cookiesConfidentiality = cookiesConfidentiality;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public static void setRewriteURI(boolean rewriteURI) {
        RequestWrapper.rewriteURI = rewriteURI;
    }
}

