/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.filter.DefaultErrorPageWritter;
import org.hdiv.filter.ValidatorError;
import org.hdiv.filter.ValidatorErrorHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultValidatorErrorHandler
implements ValidatorErrorHandler {
    protected HDIVConfig config;
    protected DefaultErrorPageWritter errorPageWritter = new DefaultErrorPageWritter();

    @Override
    public void handleValidatorError(RequestContextHolder ctx, List<ValidatorError> errors) {
        HttpServletResponse response = ctx.getResponse();
        if (this.isPageNotFoundError(errors)) {
            HttpSession session = ctx.getRequest().getSession(false);
            if (session == null || session.isNew()) {
                this.redirectToLoginPage(ctx, response);
            } else {
                ValidatorError error = errors.get(0);
                String username = error.getUserName();
                if (username == null || username == "anonymous") {
                    this.redirectToLoginPage(ctx, response);
                } else {
                    this.redirectToHomePage(ctx, response);
                }
            }
        } else {
            this.redirectToErrorPage(ctx, response);
        }
    }

    protected boolean isPageNotFoundError(List<ValidatorError> errors) {
        for (ValidatorError error : errors) {
            if (!"INVALID_PAGE_ID".equals(error.getType())) continue;
            return true;
        }
        return false;
    }

    protected void redirectToErrorPage(RequestContextHolder ctx, HttpServletResponse response) {
        if (this.config.getErrorPage() != null) {
            this.redirect(response, ctx.getContextPath() + this.config.getErrorPage());
        } else {
            this.redirectToDefaultErrorPage(ctx, response);
        }
    }

    protected void redirectToLoginPage(RequestContextHolder ctx, HttpServletResponse response) {
        if (this.config.getSessionExpiredLoginPage() != null) {
            this.redirect(response, ctx.getContextPath() + this.config.getSessionExpiredLoginPage());
        } else {
            this.redirectToErrorPage(ctx, response);
        }
    }

    protected void redirectToHomePage(RequestContextHolder ctx, HttpServletResponse response) {
        if (this.config.getSessionExpiredHomePage() != null) {
            this.redirect(response, ctx.getContextPath() + this.config.getSessionExpiredHomePage());
        } else {
            this.redirectToErrorPage(ctx, response);
        }
    }

    protected void redirect(HttpServletResponse response, String url) {
        try {
            response.sendRedirect(response.encodeRedirectURL(url));
        }
        catch (IOException e) {
            throw new RuntimeException("Cant redirect to: " + url, e);
        }
    }

    protected void redirectToDefaultErrorPage(RequestContextHolder ctx, HttpServletResponse response) {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            List editableErrors = (List)ctx.getSession().getAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR");
            ctx.getSession().removeAttribute("org.hdiv.action.EDITABLE_PARAMETER_ERROR");
            this.errorPageWritter.writeErrorPage(ctx, out, editableErrors);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("Cant redirect to the default error page", e);
        }
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    @Override
    public void handleValidatorException(RequestContextHolder context, Throwable e) {
    }
}

