/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataValidator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.IValidationResult;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.state.IParameter;
import org.hdiv.util.HDIVUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataValidator
implements IDataValidator {
    private static final Logger log = LoggerFactory.getLogger(DataValidator.class);
    protected HDIVConfig config;

    public IValidationResult validate(RequestContextHolder request, String value, String target, String parameter, IParameter stateParameter, String[] actionParamValues) {
        boolean noConfidentiality;
        boolean confidentiality = this.config.getConfidentiality();
        boolean bl = noConfidentiality = this.config.isParameterWithoutConfidentiality(request, parameter) || stateParameter != null && HDIVUtil.isNonConfidentialType(stateParameter.getEditableDataType());
        if (log.isDebugEnabled() && noConfidentiality) {
            log.debug("Parameter [" + parameter + "] is ParameterWithoutConfidentiality.");
        }
        ValidationResult result = new ValidationResult();
        if (!confidentiality || noConfidentiality) {
            if (stateParameter != null) {
                if (stateParameter.existValue(value)) {
                    result.setResult(value);
                    result.setLegal(true);
                } else {
                    result.setLegal(false);
                }
                return result;
            }
            for (int i = 0; i < actionParamValues.length; ++i) {
                if (!value.equals(actionParamValues[i])) continue;
                result.setResult(value);
                result.setLegal(true);
                return result;
            }
            result.setLegal(false);
            return result;
        }
        if (!this.isInt(value)) {
            result.setLegal(false);
            return result;
        }
        int position = Integer.parseInt(value);
        if (stateParameter != null) {
            if (stateParameter.existPosition(position)) {
                result.setLegal(true);
                result.setResult(stateParameter.getValuePosition(position));
                return result;
            }
            result.setLegal(false);
            return result;
        }
        if (actionParamValues.length > position) {
            result.setLegal(true);
            result.setResult(actionParamValues[position]);
            return result;
        }
        result.setLegal(false);
        return result;
    }

    protected boolean isInt(String data) {
        Pattern p = HDIVUtil.intPattern;
        Matcher m = p.matcher(data);
        return m.matches();
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }
}

