/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import java.io.UnsupportedEncodingException;
import java.util.ArrayDeque;
import java.util.Deque;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.AbstractDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.state.State;
import org.hdiv.state.scope.StateScope;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.state.scope.StateScopeType;
import org.hdiv.util.HDIVStateUtils;
import org.hdiv.util.HDIVUtil;
import org.hdiv.util.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataComposerMemory
extends AbstractDataComposer {
    private static final Logger log = LoggerFactory.getLogger(DataComposerMemory.class);
    protected StateScopeManager stateScopeManager;
    protected Deque<StateScopeType> scopeStack;
    protected StateScope stateScope;

    public DataComposerMemory(RequestContextHolder requestContext) {
        super(requestContext);
    }

    public void init() {
        super.init();
        this.scopeStack = new ArrayDeque<StateScopeType>();
        this.startScope(StateScopeType.PAGE);
    }

    public void startScope(StateScopeType scope) {
        this.scopeStack.push(scope);
        this.stateScope = this.getStateScope();
    }

    public void endScope() {
        this.scopeStack.pop();
        this.stateScope = this.getStateScope();
    }

    public final String beginRequest() {
        return this.beginRequest(null, "");
    }

    public String beginRequest(Method method, String action) {
        try {
            action = HDIVUtil.decodeValue(this.sb, action, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("UTF-8 encoding not supported.", e);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.beginRequest(this.createNewState(this.page.getNextStateId(), method, action));
    }

    protected IState createNewState(int stateId, Method method, String action) {
        State state = new State(stateId);
        state.setAction(action);
        state.setMethod(method);
        return state;
    }

    private final StateScope getStateScope() {
        StateScopeType type = this.scopeStack.peek();
        if (type != StateScopeType.PAGE) {
            return this.stateScopeManager.getStateScope(type);
        }
        return null;
    }

    public String beginRequest(IState state) {
        this.states.push(state);
        if (this.stateScope != null) {
            return null;
        }
        return this.toId(state);
    }

    protected String toId(IState state) {
        return HDIVStateUtils.encode(this.page.getId(), state.getId(), this.getStateSuffix(state.getTokenType()));
    }

    public String endRequest() {
        IState state = (IState)this.states.pop();
        if (this.stateScope != null) {
            return this.stateScope.addState(this.context, state, this.getStateSuffix(state.getTokenType()));
        }
        this.page.addState(state);
        if (this.page.getStatesCount() == 1) {
            this.session.addPartialPage(this.context, this.page);
        }
        return this.toId(state);
    }

    private void logCompact(HDIVException e) {
        StringBuilder sb;
        if (!this.hdivConfig.isIntegrityValidation()) {
            sb = new StringBuilder();
            sb.append("Error on page").append(e.getMessage());
            if (e.getStackTrace().length > 0) {
                sb.append(" Cl:").append(e.getStackTrace()[0].getClassName()).append(":").append(e.getStackTrace()[0].getLineNumber());
            }
        } else {
            throw e;
        }
        log.info(sb.toString());
    }

    public final void startPage() {
        try {
            this.initPage();
        }
        catch (HDIVException e) {
            this.logCompact(e);
        }
    }

    public void startPage(String parentStateId) {
        this.initPage(parentStateId);
    }

    public void startPage(IPage existingPage) {
        existingPage.markAsReused();
        this.setPage(existingPage);
    }

    public final void endPage() {
        try {
            if (this.isRequestStarted()) {
                this.endRequest();
            }
            if (this.page.getStatesCount() > 0) {
                this.session.addPage(this.context, this.page);
            } else if (log.isDebugEnabled()) {
                log.debug("The page [" + this.page.getId() + "] has no states, is not stored in session");
            }
        }
        catch (HDIVException e) {
            this.logCompact(e);
        }
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }
}

