/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.config.HDIVConfig;
import org.hdiv.context.RequestContextHolder;
import org.hdiv.dataComposer.DataComposerMemory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;
import org.hdiv.state.StateUtil;
import org.hdiv.state.scope.StateScopeManager;
import org.hdiv.state.scope.StateScopeType;
import org.hdiv.util.HDIVUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataComposerFactory {
    private static final int DEFAULT_ALLOWED_LENGTH = 4000;
    protected HDIVConfig config;
    protected ISession session;
    protected UidGenerator uidGenerator;
    protected int allowedLength = 4000;
    protected StateUtil stateUtil;
    protected StateScopeManager stateScopeManager;
    protected List<String> excludePageReuseHeaders = Arrays.asList("X-PJAX", "X-HDIV-EXCLUDE-PAGE-REUSE");

    @Deprecated
    public final IDataComposer newInstance(HttpServletRequest request) {
        return this.newInstance(HDIVUtil.getRequestContext((ServletRequest)request));
    }

    public IDataComposer newInstance(RequestContextHolder context) {
        DataComposerMemory composer = new DataComposerMemory(context);
        composer.setHdivConfig(this.config);
        composer.setSession(this.session);
        composer.setUidGenerator(this.uidGenerator);
        composer.setStateScopeManager(this.stateScopeManager);
        composer.init();
        this.initDataComposer(composer, context);
        return composer;
    }

    protected void initDataComposer(IDataComposer dataComposer, RequestContextHolder context) {
        UUID pageId;
        String hdivState = context.getHdivState();
        String preState = this.getModifyStateParameterValue(context);
        if (preState != null && preState.length() > 0) {
            pageId = this.stateUtil.getPageId(preState);
            IState state = this.stateUtil.restoreState(context, preState);
            if (pageId != null) {
                IPage page = state.getPage();
                if (page == null) {
                    page = this.session.getPage(context, pageId);
                }
                if (page != null) {
                    dataComposer.startPage(page);
                }
            }
            if (state != null) {
                dataComposer.beginRequest(state);
            }
        } else if (this.reuseExistingPage(context)) {
            if (hdivState != null && hdivState.length() > 0) {
                pageId = this.stateUtil.getPageId(hdivState);
                if (pageId != null) {
                    IPage page = this.session.getPage(context, pageId);
                    dataComposer.startPage(page);
                } else {
                    dataComposer.startPage(hdivState);
                }
            } else {
                dataComposer.startPage(hdivState);
            }
        } else {
            dataComposer.startPage(hdivState);
        }
        String url = context.getUrlWithoutContextPath();
        StateScopeType scope = this.config.isLongLivingPages(url);
        if (scope != null) {
            dataComposer.startScope(scope);
        }
    }

    protected String getModifyStateParameterValue(RequestContextHolder context) {
        String paramName = context.getHdivModifyParameterName();
        return paramName != null ? context.getParameter(paramName) : null;
    }

    protected boolean reuseExistingPage(RequestContextHolder context) {
        return this.config.isReuseExistingPageInAjaxRequest() && context.isAjax() && !this.excludePageReuseInAjax(context);
    }

    protected final boolean excludePageReuseInAjax(RequestContextHolder request) {
        for (String header : this.excludePageReuseHeaders) {
            String headerValue = request.getHeader(header);
            if (headerValue == null) continue;
            return true;
        }
        return false;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public void setUidGenerator(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }

    public void setAllowedLength(int allowedLength) {
        this.allowedLength = allowedLength;
    }

    public void setStateUtil(StateUtil stateUtil) {
        this.stateUtil = stateUtil;
    }

    public void setStateScopeManager(StateScopeManager stateScopeManager) {
        this.stateScopeManager = stateScopeManager;
    }

    public void setExcludePageReuseHeaders(List<String> excludePageReuseHeaders) {
        this.excludePageReuseHeaders = excludePageReuseHeaders;
    }
}

